﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.IO;
using System.Linq;
using System.Net;
using System.Net.Sockets;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace HtcDaemon.DirectSocket
{
    internal class DirectSocketTargetDetector : ITargetDetector
    {
        public event EventHandler<TargetDetectedEventArgs> Detected
        {
            add { innerTargetDetector.Detected += value; }
            remove { innerTargetDetector.Detected -= value; }
        }

        private bool disposed;
        private SocketTargetDetector innerTargetDetector;

        // throws SocketException
        public DirectSocketTargetDetector(int udpPort)
        {
            this.innerTargetDetector = new SocketTargetDetector(
                udpPort,
                socket => new DirectSocketHostTargetConnectionBuilder().Build(socket));
        }

        ~DirectSocketTargetDetector()
        {
            this.Dispose(false);
        }

        public void Dispose()
        {
            this.Dispose(true);
            GC.SuppressFinalize(this);
        }

        public void MakeTargetConnectionAndRaiseDetected(IPEndPoint endPoint)
        {
            this.innerTargetDetector.MakeTargetConnectionAndRaiseDetected(endPoint);
        }

        protected virtual void Dispose(bool disposing)
        {
            if (!this.disposed)
            {
                if (disposing)
                {
                    // ここでマネージドリソースをDisposeする
                    innerTargetDetector.Dispose();
                }

                // ここでアンマネージドリソースを解放する
                this.disposed = true;
            }
        }

        public void Start()
        {
            innerTargetDetector.Start();
        }

        public void Stop()
        {
            innerTargetDetector.Stop();
        }
    }
}
