﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Net.Sockets;
using System.Text;
using System.Threading.Tasks;
using Nintendo.Htcs;

namespace HtcDaemon.DirectSocket
{
    // DirectSocket の場合はチャンネルの管理をせずソケット直、コントロールチャンネルのみ
    internal class DirectSocketMux : Mux
    {
        private bool disposed;
        private HtcsPeerName targetPeerName;
        private EndPoint targetEndPoint;
        private DirectSocketChannel controlChannel;

        public override HtcsPeerName TargetPeerName { get { return targetPeerName; } }
        public override string TargetEndPointString { get { return targetEndPoint.ToString(); } }
        public override IChannel ControlChannel { get { return controlChannel; } }

        public DirectSocketMux(Socket socket, HtcsPeerName targetPeerName)
        {
            this.controlChannel = new DirectSocketChannel(socket, targetPeerName);
            this.targetPeerName = targetPeerName;
            this.targetEndPoint = socket.RemoteEndPoint;
            this.controlChannel.Disconnected += OnDisconnected;
        }

        protected override void Dispose(bool disposing)
        {
            if (!this.disposed)
            {
                if (disposing)
                {
                    // ここでマネージドリソースをDisposeする
                    this.controlChannel.Cancel();
                    this.controlChannel.Dispose();
                }
                // ここでアンマネージドリソースを解放する
                this.disposed = true;
            }

            // 基底クラスのDisposeを呼び出す
            base.Dispose(disposing);
        }

        public override void Start()
        {
        }

        public override void Stop()
        {
            this.controlChannel.Cancel();
        }

        protected override IChannel CreateDataChannelCore(int channelId, uint remoteBufferLength)
        {
            // DirectSocket ではターゲット自身が作成した socket で通信するため、チャンネルを管理しない
            throw new NotSupportedException();
        }

        private void OnDisconnected(object sender, ChannelEventArgs e)
        {
            RaiseDisconnected();
        }
    }
}
