﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Net.Sockets;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace HtcDaemon.Bridging
{
    internal class ProxyHostAppListener : IHostAppListener
    {
        private bool disposed;
        private Socket listener;
        private string htcsPortName;

        public IPEndPoint LocalEndPoint { get { return (IPEndPoint)listener.LocalEndPoint; } }

        public ProxyHostAppListener(string htcsPortName, int port)
        {
            this.htcsPortName = htcsPortName;
            this.listener = new Socket(AddressFamily.InterNetwork, SocketType.Stream, ProtocolType.Tcp);
            // TODO: IPAddress.Any に bind する場合、ファイアウォールが有効になるのをなんとかする
            this.listener.Bind(new IPEndPoint(IPAddress.Loopback, port));
            this.listener.Listen(1);
        }

        ~ProxyHostAppListener()
        {
            this.Dispose(false);
        }

        public void Dispose()
        {
            this.Dispose(true);
            GC.SuppressFinalize(this);
        }

        protected virtual void Dispose(bool disposing)
        {
            if (!this.disposed)
            {
                if (disposing)
                {
                    listener.Close();
                }

                // ここでアンマネージドリソースを解放する
                this.disposed = true;
            }
        }

        public Socket Accept()
        {
            return listener.Accept();
        }
    }
}
