﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Nintendo.FsFileCacheSimulator.FileSystem;

namespace Nintendo.FsFileCacheSimulator.Simulation
{
    internal class SimulatedFileSystem
    {
        // TODO: StorageType を引数に取らない
        private SimulatedFileSystem(string name, FileSystemType fileSystemType, StorageType storageType)
        {
            MountName = name;
            FileSystemType = fileSystemType;
            StorageType = storageType;
            Statistics = new FileSystemStatistics();
        }
        public static SimulatedFileSystem MountRom(string name, StorageType storageType)
        {
            return new SimulatedFileSystem(name, FileSystemType.Rom, storageType);
        }
        public static SimulatedFileSystem MountSaveData(string name, StorageType storageType)  // 本来はユーザアカウント ID も引数に取る
        {
            return new SimulatedFileSystem(name, FileSystemType.SaveData, storageType);
        }
        public static SimulatedFileSystem MountCacheStorage(string name, StorageType storageType)
        {
            return new SimulatedFileSystem(name, FileSystemType.CacheStorage, storageType);
        }
        public static SimulatedFileSystem MountTemporaryStorage(string name, StorageType storageType)
        {
            return new SimulatedFileSystem(name, FileSystemType.TemporaryStorage, storageType);
        }

        public string MountName { get; }

        public FileSystemType FileSystemType { get; }

        // TODO: 削除する
        public StorageType StorageType { get; }

        public FileSystemStatistics Statistics { get; set; }

        public class AccessEventArgs : EventArgs
        {
            public string Path { get; }
            public ulong Offset { get; }
            public ulong Size { get; }
            public AccessEventArgs(string path, ulong offset, ulong size)
            {
                Path = path;
                Offset = offset;
                Size = size;
            }
        }

        public event EventHandler<AccessEventArgs> ReadFileEvent;
        public event EventHandler<AccessEventArgs> WriteFileEvent;

        public void ReadFile(string path, ulong offset, ulong size)
        {
            Statistics.ReadIpcCount++;
            Statistics.EstimatedReadTime += AccessTimeCalculator.GetReadAccessTime(size, FileSystemType, StorageType);
            Statistics.ReadBytes += size;

            ReadFileEvent(this, new AccessEventArgs(path, offset, size));
        }

        public void WriteFile(string path, ulong offset, ulong size)
        {
            Statistics.WriteIpcCount++;
            Statistics.EstimatedWriteTime += AccessTimeCalculator.GetWriteAccessTime(size, FileSystemType, StorageType);
            Statistics.WrittenBytes += size;

            WriteFileEvent(this, new AccessEventArgs(path, offset, size));
        }
    }
}
