﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Nintendo.FsFileCacheSimulator.FileSystem;

namespace Nintendo.FsFileCacheSimulator.Simulation
{
    internal class FileSystemSimulationResult
    {
        public FileSystemSimulationResult(
            string mountName,
            FileSystemType fileSystemType,
            FileSystemStatistics fsStatistics,
            ulong startTimeMilliseconds,
            ulong endTimeMilliseconds,
            TimeSpan logBasedReadTime,
            TimeSpan logBasedWriteTime,
            ICacheSystem cacheSystem,
            CacheStatistics cacheStatistics)
        {
            MountName = mountName;
            FileSystemType = fileSystemType;
            FileSystemStatistics = fsStatistics;
            StartTimeMilliseconds = startTimeMilliseconds;
            EndTimeMilliseconds = endTimeMilliseconds;
            LogBasedReadTime = logBasedReadTime;
            LogBasedWriteTime = logBasedWriteTime;
            CacheSystem = cacheSystem;
            CacheStatistics = cacheStatistics;
        }
        public string MountName { get; }
        public FileSystemType FileSystemType { get; }
        public FileSystemStatistics FileSystemStatistics { get; }
        public ulong StartTimeMilliseconds { get; }
        public ulong EndTimeMilliseconds { get; }
        public TimeSpan LogBasedReadTime { get; }
        public TimeSpan LogBasedWriteTime { get; }
        public ICacheSystem CacheSystem { get; }
        public CacheStatistics CacheStatistics { get; }
    }
}
