﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using YamlDotNet.Serialization;
using YamlDotNet.Serialization.NamingConventions;

namespace Nintendo.FsFileCacheSimulator.FileSystem
{
    internal class AccessLogSerializer
    {
        public static void Serialize(StreamWriter writer, IEnumerable<IReadOnlyDictionary<object, object>> serializingLogs)
        {
            var serializer = new Serializer(SerializationOptions.JsonCompatible, new UnderscoredNamingConvention());

            writer.WriteLine("FsFileCacheSimulator simulated access log");
            foreach (var log in serializingLogs)
            {
                writer.Write("FS_ACCESS: ");
                serializer.Serialize(writer, log);
            }
        }

        public static IEnumerable<IReadOnlyDictionary<object, object>> Deserialize(StreamReader reader)
        {
            var deserializer = new Deserializer(namingConvention: new UnderscoredNamingConvention());

            while (!reader.EndOfStream)
            {
                var line = reader.ReadLine();

                var logHeaderIndex = line.IndexOf("FS_ACCESS: ");
                if (logHeaderIndex >= 0)
                {
                    var jsonString = line.Substring(logHeaderIndex + "FS_ACCESS: ".Length);

                    yield return deserializer.Deserialize(new StringReader(jsonString)) as IReadOnlyDictionary<object, object>;
                }
            }
        }
    }
}
