﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using Microsoft.VisualStudio.TestTools.UnitTesting;

namespace DeviceTreeDataCollector.DeviceTree
{
    [TestClass]
    public class DeviceTreeReaderTests
    {
        [TestMethod]
        public void PropertyReadTest()
        {
            var dtb = new DeviceTreeReader("./tegra210_fortest.dtb");
            var targetNode = dtb.FindNode("/pcie-controller@01003000");
            ReadAddressRangeListProperty(targetNode, "reg");
            ReadIntegerListProperty(targetNode, "interrupts");
            ReadStringListProperty(targetNode, "interrupt-names");

            var rootNode = dtb.FindNode("/");
            ReadPhandleProperty(rootNode, "interrupt-parent");
        }

        private void ReadAddressRangeListProperty(DeviceTreeNode node, string propertyName)
        {
            var property = node.GetValue(propertyName, DeviceTreeProperty.PropertyType.AddressRangeList);
            Console.WriteLine($"Address ranges obtained on `{propertyName}`:");
            foreach (var range in property.GetValues<AddressRange>())
            {
                Console.WriteLine($"  BeginAddress 0x{range.BeginAddress:x} / Size 0x{range.Size:x}");
            }
        }

        private void ReadIntegerListProperty(DeviceTreeNode node, string propertyName)
        {
            var property = node.GetValue(propertyName, DeviceTreeProperty.PropertyType.IntegerList);
            Console.WriteLine($"Integers obtained on `{propertyName}`:");
            foreach (var value in property.GetValues<int>())
            {
                Console.WriteLine($"  {value}");
            }
        }
        private void ReadStringListProperty(DeviceTreeNode node, string propertyName)
        {
            var property = node.GetValue(propertyName, DeviceTreeProperty.PropertyType.StringList);
            Console.WriteLine($"Strings obtained on `{propertyName}`:");
            foreach (var value in property.GetValues<string>())
            {
                Console.WriteLine($"  {value}");
            }
        }
        private void ReadPhandleProperty(DeviceTreeNode node, string propertyName)
        {
            var property = node.GetValue(propertyName, DeviceTreeProperty.PropertyType.Phandle);
            Console.WriteLine($"phandle obtained on `{propertyName}`:");
            foreach (var phandle in property.GetValues<Phandle>())
            {
                Console.WriteLine($"  {phandle}");
            }
        }
    }
}
