﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;

namespace DeviceTreeDataCollector
{
    public class PropertyCollectParameter
    {
        public string Id { get; set; }
        public string Type { get; set; }
        public string NodePath { get; set; }
        public string PropertyName { get; set; }
        public Selector Selector { get; set; }
        public Modifier Modifier { get; set; }
    }

    public class Selector
    {
        public List<int> TargetIndex { get; set; }
        public int UnitSize { get; set; }
        public int TargetCellInUnit { get; set; }
    }

    public class Modifier
    {
        public int IntegerValueOffset { get; set; }
    }
}
