﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using Nintendo.Foundation.IO;
using ContentsUploader.Assistants;

namespace ContentsUploader.Commands
{
    public class ListVersionCommand : CommandBase
    {
        //! Nsp 指定
        [CommandLineOption('s', "input", DefaultValue = "", Description = "Nsp of list-version setting")]
        public override string NspPathOption { get; set; }

        //! 単体 ID 指定
        [CommandLineOption("content-meta-id", DefaultValue = "", Description = "Content Meta ID of list-version setting")]
        public override string ContentMetaIdOption { get; set; }

        public override void Run()
        {
            Run("List Version");
        }

        protected override bool RunByContentMetaId(Id64 contentMetaId)
        {
            var d4c = new D4cHelper(Setting.Current);
            return d4c.ListVersionByContentMeta(contentMetaId);
        }
    }
}
