﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.IO;

namespace CommandUtility
{
    public class SdkPath
    {
        public static FileInfo FindToolPath(string toolName, string relativePath = null, string rootRelativePath = null, string specifiedTool = null)
        {
            var currentApplicationPosition = System.IO.Path.GetDirectoryName(System.Reflection.Assembly.GetExecutingAssembly().Location);

            // specifiedPosition
            if (specifiedTool != null)
            {
                if (File.Exists(specifiedTool))
                {
                    return new FileInfo(specifiedTool);
                }
            }

            // samePosition
            {
                var targetApplicationPath = Path.Combine(currentApplicationPosition, toolName);

                if (File.Exists(targetApplicationPath))
                {
                    return new FileInfo(targetApplicationPath);
                }
            }

            // relativePosition
            if (relativePath != null)
            {
                var targetApplicationPath = Path.Combine(currentApplicationPosition, relativePath);

                if (File.Exists(targetApplicationPath))
                {
                    return new FileInfo(targetApplicationPath);
                }
            }

            // toolRelativePath
            if (rootRelativePath != null)
            {
                var targetApplicationPath = Path.Combine(FindSdkRoot(currentApplicationPosition), "Tools", "CommandLineTools", rootRelativePath);

                if (File.Exists(targetApplicationPath))
                {
                    return new FileInfo(targetApplicationPath);
                }
            }

            // rootRelativePath
            if (rootRelativePath != null)
            {
                var targetApplicationPath = Path.Combine(FindSdkRoot(currentApplicationPosition), rootRelativePath);

                if (File.Exists(targetApplicationPath))
                {
                    return new FileInfo(targetApplicationPath);
                }
            }

            // toolPath
            {
                var targetApplicationPath = Path.Combine(FindSdkRoot(currentApplicationPosition), "Tools", "CommandLineTools", toolName);

                if (File.Exists(targetApplicationPath))
                {
                    return new FileInfo(targetApplicationPath);
                }
            }

            // toolPath(CommandLineTools/<ToolName>/<ToolName>.exe)
            {
                var baseName = Path.GetFileNameWithoutExtension(toolName);

                var targetApplicationPath = Path.Combine(FindSdkRoot(currentApplicationPosition), "Tools", "CommandLineTools", baseName, toolName);

                if (File.Exists(targetApplicationPath))
                {
                    return new FileInfo(targetApplicationPath);
                }
            }

            throw new FileNotFoundException(string.Format("{0} is not found.", toolName));
        }

        public static string FindSdkRoot()
        {
            return FindSdkRoot(System.IO.Path.GetDirectoryName(System.Reflection.Assembly.GetExecutingAssembly().Location));
        }

        public static string FindSdkRoot(string path)
        {
            string startPath = path;
            string currentDirectory = startPath;
            string rootDirectory = Path.GetPathRoot(currentDirectory);

            while (rootDirectory != currentDirectory)
            {
                string sigloRootMarkFilePath = System.IO.Path.Combine(currentDirectory, SdkRootMarkFileName);
                if (System.IO.File.Exists(sigloRootMarkFilePath))
                {
                    return currentDirectory;
                }

                currentDirectory = System.IO.Path.GetFullPath(System.IO.Path.Combine(currentDirectory, ".."));
            }

            throw new InvalidDataException(string.Format("Not found NintendoSdkRootMark\nPath=\n{0}", startPath));
        }

        public const string SdkRootMarkFileName = "NintendoSdkRootMark";
    }
}
