﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Nintendo.Foundation.IO;

namespace CommandUtility
{
    /// <summary>
    /// Sdk バージョンを付加するだけの ToolFoundation の CommandLineParser のラッパ
    /// </summary>
    public class SdkCommandLineParser
    {
        public static bool ParseArgs<TParam>(IEnumerable<string> args, out TParam result) where TParam : class, new()
        {
            CommandLineParserSettings settings = new CommandLineParserSettings();
            settings.Version = SdkVersion.GetSdkVersion();
            return new CommandLineParser(settings).ParseArgs<TParam>(args, out result);
        }

        public static bool ParseArgs<TParam>(IEnumerable<string> args, out TParam result, Action<CommandLineErrorInfo> errorAction) where TParam : class, new()
        {
            CommandLineParserSettings settings = new CommandLineParserSettings();
            settings.Version = SdkVersion.GetSdkVersion();
            return new CommandLineParser(settings).ParseArgs<TParam>(args, out result, errorAction);
        }

        public static bool ParseArgs<TParam>(CommandLineParserSettings settings, IEnumerable<string> args, out TParam result) where TParam : class, new()
        {
            settings.Version = SdkVersion.GetSdkVersion();
            return new CommandLineParser(settings).ParseArgs<TParam>(args, out result);
        }

        public static bool ParseArgs<TParam>(CommandLineParserSettings settings, IEnumerable<string> args, out TParam result, Action<CommandLineErrorInfo> errorAction) where TParam : class, new()
        {
            settings.Version = SdkVersion.GetSdkVersion();
            return new CommandLineParser(settings).ParseArgs<TParam>(args, out result, errorAction);
        }
    }
}
