﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace ElfLibrary
{
    using System;

    /// <summary>
    /// ELF ファイルのマシンタイプです。
    /// </summary>
    public enum ElfMachineType
    {
        /// <summary>
        /// PowerPC です。
        /// </summary>
        PowerPC = 20, // EM_PPC

        /// <summary>
        /// ARM です。
        /// </summary>
        ARM = 40, // EM_ARM

        /// <summary>
        /// AArch64 です。
        /// </summary>
        AArch64 = 183, // EM_AARCH64

        /// <summary>
        /// サポート外のマシンタイプです。
        /// </summary>
        Unknown
    }

    /// <summary>
    /// ELFファイルのバイトオーダタイプです。
    /// </summary>
    public enum ElfByteOrderType
    {
        /// <summary>
        /// リトルエンディアンです。
        /// </summary>
        LittleEndian = 1, // ELFDATA2LSB

        /// <summary>
        /// ビッグエンディアンです。
        /// </summary>
        BigEndian = 2, // ELFDATA2MSB

        /// <summary>
        /// Invalid Data Encoding
        /// </summary>
        None,
    }

    /// <summary>
    /// ELFファイルのアーキテクチャタイプです。
    /// </summary>
    public enum ElfArchitectureType
    {
        /// <summary>
        /// 32-bit のアーキテクチャです。
        /// </summary>
        Elf32 = 1, //ELFCLASS32

        /// <summary>
        /// 64-bit のアーキテクチャです。
        /// </summary>
        Elf64 = 2, //ELFCLASS64

        /// <summary>
        /// Invalid Class
        /// </summary>
        None = 0,
    }
}
