﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace ElfLibrary
{
    using System;
    using System.IO;

    /// <summary>
    /// シンボルの見え方や振る舞い
    /// </summary>
    public enum ElfSymbolBinding
    {
        LOCAL = 0,
        GLOBAL = 1,
        WEAK = 2,
        LOOS = 10,
        HIOS = 12,
        LOPROC = 13,
        HIPROC = 15,
    }

    /// <summary>
    /// シンボルの一般的な分類
    /// </summary>
    public enum ElfSymbolType
    {
        NOTYPE = 0,
        OBJECT = 1,
        FUNC = 2,
        SECTION = 3,
        FILE = 4,
        LOOS = 10,
        HIOS = 12,
        LOPROC = 13,
        HIPROC = 15,
    }

    /// <summary>
    /// ELF Symbol Table のヘッダのベースクラス
    /// </summary>
    public abstract class ElfSymbolTableEntry : IElfFile
    {
        // 32-bit と 64-bit のヘッダで順番が違う
        public uint Name { get; set; }
        public byte Info { get; set; }
        public byte Other { get; set; }
        public ushort SectionIndex { get; set; }
        public ulong Value { get; set; }
        public ulong Size { get; set; }

        /// <summary>
        /// ファイルから SymbolHeader を読み込みます。
        /// </summary>
        /// <param name="reader">読み込みインスタンス</param>
        public abstract void ReadElfFile(ElfBinaryReader reader);

        /// <summary>
        /// ファイルに SymbolHeader を書き込みます。
        /// </summary>
        /// <param name="writer">書き込みインスタンス</param>
        public abstract void WriteElfData(ElfBinaryWriter writer);
    }
}
