﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace ElfLibrary.Elf32
{
    using System;
    using System.IO;

    /// <summary>
    /// ELF 32bit Symbol Table のヘッダクラス
    /// </summary>
    public class Elf32SymbolTableEntry : ElfSymbolTableEntry
    {
        public const ushort Elf32HeaderSize = 16;

        /// <summary>
        /// ファイルから SymbolHeader を読み込みます。
        /// </summary>
        /// <param name="reader">読み込みインスタンス</param>
        public override void ReadElfFile(ElfBinaryReader reader)
        {
            Name = reader.ReadUInt32();
            Value = reader.ReadUInt32();
            Size = reader.ReadUInt32();
            Info = reader.ReadByte();
            Other = reader.ReadByte();
            SectionIndex = reader.ReadUInt16();
        }

        /// <summary>
        /// ファイルに SymbolHeader を書き込みます。
        /// </summary>
        /// <param name="writer">書き込みインスタンス</param>
        /// <param name="offset">移動量 (マイナス値の時はシークしない) </param>
        /// <param name="origin">移動開始位置</param>
        /// <returns>書き込みの成否</returns>
        public override void WriteElfData(ElfBinaryWriter writer)
        {
            checked
            {
                writer.WriteUInt32(Name);
                writer.WriteUInt32((uint)Value);
                writer.WriteUInt32((uint)Size);
                writer.WriteByte(Info);
                writer.WriteByte(Other);
                writer.WriteUInt16(SectionIndex);
            }
        }
    }
}
