﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/fs/fs_IStorage.h>
#include "IFileSystemArchiveReader.h"

namespace Nintendo { namespace Authoring { namespace FileSystemMetaLibrary {

using namespace System;
using namespace System::IO;
using namespace System::Collections;
using namespace System::Collections::Generic;

using namespace nn;
using namespace nn::fssystem;

    class Sha256PartitionFileSystemArchiveReaderImpl;
    public ref class Sha256PartitionFileSystemArchiveReader : IFileSystemArchiveReader
    {
    public:
        Sha256PartitionFileSystemArchiveReader(Stream^ stream);
        Sha256PartitionFileSystemArchiveReader(Stream^ stream, array<Byte>^ hash);

        ~Sha256PartitionFileSystemArchiveReader();
        !Sha256PartitionFileSystemArchiveReader();

        virtual List<Tuple<String^, Int64>^>^ ListFileInfo();
        virtual List<Tuple<String^, Int64>^>^ ListFileInfo(String^ rootPath);
        virtual List<Tuple<Int64, Int64>^>^ GetFileFragmentList(String^ fileName);
        virtual int64_t GetFileSize(String^ fileName);
        virtual array<byte>^ ReadFile(String^ fileName, int64_t offset, int64_t size);
        virtual int64_t GetBaseSize();
        virtual array<byte>^ ReadBase(int64_t offset, int64_t size);

    internal:
        Sha256PartitionFileSystemArchiveReader(std::shared_ptr<fs::IStorage> storage);
        void OpenFileStorage(std::shared_ptr<fs::IStorage>* outValue, String^ fileName);

    private:
        Sha256PartitionFileSystemArchiveReaderImpl* m_Impl;
    };

}}}
