﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "HsmInterfaceManager.h"
#include "IEncryptor.h"

namespace Nintendo { namespace Authoring { namespace CryptoLibrary {

using namespace System;

public ref class HsmAes128CbcCryptoDriver : ICbcModeEncryptor
{
    public:
        property int KeySize
        {
            virtual int get() { return 16; }
        }

        HsmAes128CbcCryptoDriver(Aes128KeyIndex keyIndex, byte keyGeneration)
        {
            m_HsmInterface = gcnew HsmInterface();
            m_HsmKeyIndex = keyIndex;
            m_KeyGeneration = keyGeneration;
            GC::KeepAlive(this);
        }

        ~HsmAes128CbcCryptoDriver()
        {
            this->!HsmAes128CbcCryptoDriver();
        }

        !HsmAes128CbcCryptoDriver()
        {
        }

        virtual void EncryptBlock(array<Byte>^ iv, array<Byte>^ src, int srcOffset, int srcSize, array<Byte>^ dst, int dstOffset)
        {
            pin_ptr<unsigned char> pinSrc = &src[srcOffset];
            pin_ptr<unsigned char> pinIv = &iv[0];
            pin_ptr<unsigned char> pinDst = &dst[dstOffset];

            m_HsmInterface->EncryptAes128Cbc(m_HsmKeyIndex, m_KeyGeneration, pinDst, srcSize, pinSrc, srcSize, pinIv, KeySize);

            pinSrc = nullptr;
            pinDst = nullptr;

            GC::KeepAlive(this);
        }

        virtual void DecryptBlock(array<Byte>^ iv, array<Byte>^ src, int srcOffset, int srcSize, array<Byte>^ dst, int dstOffset)
        {
            pin_ptr<unsigned char> pinSrc = &src[srcOffset];
            pin_ptr<unsigned char> pinIv = &iv[0];
            pin_ptr<unsigned char> pinDst = &dst[dstOffset];

            m_HsmInterface->DecryptAes128Cbc(m_HsmKeyIndex, m_KeyGeneration, pinDst, srcSize, pinSrc, srcSize, pinIv, KeySize);

            pinSrc = nullptr;
            pinDst = nullptr;

            GC::KeepAlive(this);
        }

    private:
        HsmInterface^ m_HsmInterface;
        Aes128KeyIndex m_HsmKeyIndex;
        byte m_KeyGeneration;
    };

}}}
