﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.IO;
using System.Linq;
using System.Reflection;
using System.Text;
using System.Text.RegularExpressions;
using System.Xml.Serialization;
using Nintendo.Authoring.FileSystemMetaLibrary;

namespace Nintendo.Authoring.AuthoringLibrary
{
    [XmlRoot("Title", IsNullable = false)]
    public class UnpublishableErrorTitleModel
    {
        [XmlElement("Japanese", IsNullable = false)]
        public string Japanese { get; set; }
        [XmlElement("English", IsNullable = false)]
        public string English { get; set; }
        static public UnpublishableErrorTitleModel Create(string japanese, string english)
        {
            var model = new UnpublishableErrorTitleModel();
            model.Japanese = japanese;
            model.English = english;
            return model;
        }
    }

    [XmlRoot("Description", IsNullable = false)]
    public class UnpublishableErrorDescriptionModel
    {
        [XmlElement("Japanese", IsNullable = false)]
        public string Japanese { get; set; }
        [XmlElement("English", IsNullable = false)]
        public string English { get; set; }
        static public UnpublishableErrorDescriptionModel Create(string japanese, string english)
        {
            var model = new UnpublishableErrorDescriptionModel();
            model.Japanese = japanese;
            model.English = english;
            return model;
        }
    }

    [XmlRoot("Message", IsNullable = false)]
    public class UnpublishableErrorMessageModel
    {
        [XmlElement("Id", IsNullable = false)]
        public string Id { get; set; }
        [XmlElement("Title", IsNullable = false)]
        public UnpublishableErrorTitleModel Title { get; set; }
        [XmlElement("Description", IsNullable = false)]
        public UnpublishableErrorDescriptionModel Description { get; set; }
        public static UnpublishableErrorMessageModel Create(string id, UnpublishableErrorTitleModel title, UnpublishableErrorDescriptionModel description)
        {
            var model = new UnpublishableErrorMessageModel();
            model.Id = id;
            model.Title = title;
            model.Description = description;
            return model;
        }
    }

    [XmlRoot("Error", IsNullable = false)]
    public class UnpublishableErrorDetailModel
    {
        [XmlElement("Type", IsNullable = false)]
        public string Type { get; set; }
        [XmlElement("Message", IsNullable = false)]
        public UnpublishableErrorMessageModel Message { get; set; }
        public static UnpublishableErrorDetailModel Create(string type, UnpublishableErrorMessageModel message)
        {
            var model = new UnpublishableErrorDetailModel();
            model.Type = type;
            model.Message = message;
            return model;
        }
    }

    [XmlRoot("Content", IsNullable = false)]
    public class UnpublishableErrorContentModel
    {
        [XmlElement("Id", IsNullable = false)]
        public string Id { get; set; }
        [XmlElement("Type", IsNullable = false)]
        public string Type { get; set; }
        [XmlElement("ProgramIndex", IsNullable = false)]
        public string ProgramIndex { get; set; }
        [XmlElement("Error", IsNullable = false)]
        public List<UnpublishableErrorDetailModel> ErrorList { get; set; }
        [XmlIgnore] // 内部用の管理情報なのでシリアライズ対象に含めない
        public string AocIndex { get; set; }
        public static UnpublishableErrorContentModel Create(string id, string type, string programIndex, string aocIndex, List<UnpublishableErrorDetailModel> errorList)
        {
            var model = new UnpublishableErrorContentModel();
            model.Id = id;
            model.Type = type;
            model.ProgramIndex = programIndex;
            model.ErrorList = errorList;
            model.AocIndex = aocIndex;
            return model;
        }
    }

    [XmlRoot("UnpublishableError", IsNullable = false)]
    public class UnpublishableErrorModel
    {
        [XmlElement("Content", IsNullable = false)]
        public List<UnpublishableErrorContentModel> Contents { get; set; }
        public static UnpublishableErrorModel Create()
        {
            var model = new UnpublishableErrorModel();
            model.Contents = new List<UnpublishableErrorContentModel>();
            return model;
        }
    }
}
