﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System.Collections.Generic;
using System.Linq;

namespace Nintendo.Authoring.AuthoringLibrary
{
    public class Range
    {
        public long Offset { get; private set; }
        public long Size { get; private set; }
        public long End { get { return Offset + Size; } }
        public Range(long offset, long size)
        {
            Offset = offset;
            Size = size;
        }
        internal void SetSize(long size)
        {
            Size = size;
        }
    }

    public class RangeList : List<Range>
    {
        public RangeList() : base()
        {
        }
        public void MergingAdd(Range range)
        {
            if (this.Count == 0)
            {
                this.Add(range);
                return;
            }

            var prevList = this.Where(e => e.Offset <= range.Offset);
            if (prevList.Count() == 0)
            {
                this.Insert(0, range);
                TryMergeToNext(0);
                return;
            }

            var prev = prevList.Last();
            if ((range.Offset <= prev.End) && (prev.End < range.End))
            {
                prev.SetSize(prev.Size + (range.End - prev.End));
                TryMergeToNext(this.IndexOf(prev));
            }
            else if (prev.End < range.Offset)
            {
                int index = this.IndexOf(prev);
                this.Insert(index + 1, range);
                TryMergeToNext(index + 1);
            }
            else
            {
                return;
            }
        }
        private void TryMergeToNext(int index)
        {
            if (index == this.Count - 1)
            {
                return;
            }

            Range range = this[index];
            Range nextRange = this[index + 1];
            if (range.End < nextRange.Offset)
            {
                return;
            }
            else
            {
                range.SetSize(range.Size + (nextRange.End - range.End));
                this.Remove(nextRange);
                TryMergeToNext(index);
            }
        }
        public RangeList GetDuplicatedDeletedList(RangeList rangeList)
        {
            RangeList targetRangeList = new RangeList();
            foreach (var range in this)
            {
                targetRangeList.MergingAdd(range);
            }

            if (targetRangeList.Count == 0)
            {
                return targetRangeList;
            }

            int index = 0;
            Range currentRange = targetRangeList[0];
            foreach (var range in rangeList)
            {
                while (true)
                {
                    while (currentRange.End <= range.Offset)
                    {
                        index++;
                        if (index == targetRangeList.Count)
                        {
                            return targetRangeList;
                        }
                        currentRange = targetRangeList[index];
                    }

                    if (currentRange.Offset >= range.End)
                    {
                        break;
                    }

                    bool isEndInclude = currentRange.End <= range.End;
                    bool isOffsetInclude = currentRange.Offset >= range.Offset;
                    if (isOffsetInclude && isEndInclude)
                    {
                        targetRangeList.Remove(currentRange);
                        if (index == targetRangeList.Count)
                        {
                            --index;
                        }
                    }
                    else if (isOffsetInclude && !isEndInclude)
                    {
                        Range newRange = new Range(range.End, currentRange.End - range.End);
                        targetRangeList.Remove(currentRange);
                        targetRangeList.MergingAdd(newRange);
                    }
                    else if (!isOffsetInclude && isEndInclude)
                    {
                        Range newRange = new Range(currentRange.Offset, range.Offset - currentRange.Offset);
                        targetRangeList.Remove(currentRange);
                        targetRangeList.MergingAdd(newRange);
                    }
                    else if (!isOffsetInclude && !isEndInclude)
                    {
                        Range newRange1 = new Range(currentRange.Offset, range.Offset - currentRange.Offset);
                        Range newRange2 = new Range(range.End, currentRange.End - range.End);
                        targetRangeList.Remove(currentRange);
                        targetRangeList.MergingAdd(newRange1);
                        targetRangeList.MergingAdd(newRange2);
                    }

                    if (targetRangeList.Count == 0)
                    {
                        return targetRangeList;
                    }

                    currentRange = targetRangeList[index];
                }
            }
            return targetRangeList;
        }
    }
}
