﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.IO;

namespace Nintendo.Authoring.AuthoringLibrary
{
    public class LogoManager
    {
        public class LogoData
        {
            public LogoData(byte[] data, string fileName)
            {
                Data = data;
                FileName = fileName;
            }
            public byte[] Data { get; private set; }
            public string FileName { get; private set; }
        }

        static LogoData[] DefaultLogoData =
        {
            new LogoData(ContentArchiveLibrary.Logo.NintendoLogo, "NintendoLogo.png"),
            new LogoData(ContentArchiveLibrary.Logo.StartupMovie, "StartupMovie.gif"),
        };
        public static LogoData[] GetDefaultLogoData()
        {
            return DefaultLogoData;
        }


        public static void ExtractDefaultLogoData(string path)
        {
            if (!Directory.Exists(path))
            {
                Directory.CreateDirectory(path);
            }

            foreach(var logo in DefaultLogoData)
            {
                var filePath = Path.Combine(path, logo.FileName);
                using (var fs = File.Open(filePath, FileMode.Create))
                {
                    fs.Write(logo.Data, 0, logo.Data.Length);
                }
            }
        }
    }
}
