﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/sm/sm_Types.h>
#include <nn/os/os_MultipleWaitTypes.h>

namespace nn { namespace sm {

    typedef Result (*ResumeImplFuncType)(os::MultiWaitHolderType* pSession);

    Result StartRegisterRetry(ServiceName key);
    void   ProcessRegisterRetry(os::MultiWaitHolderType* pSession);

    void   TriggerResume(ServiceName key);

    void   TestAndResume(ResumeImplFuncType resume);


}}  // namespace nn::sm
