﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Result.h>
#include <nn/sf/sf_NativeHandle.h>
#include <nn/os/os_Types.h>
#include <nn/ncm/ncm_ProgramLocation.h>
#include <nn/pm/pm_ShellApi.h>
#include <nn/pm/pm_DebugMonitorApi.h>

namespace nn { namespace pm {

    const int ProcessCountMax = 64;

    class ProcessManager
    {
    public:
        nn::Result LaunchProgram(nn::os::ProcessId* pOut, const ncm::ProgramLocation& location, std::int32_t flags) NN_NOEXCEPT;
        nn::Result TerminateProcess(nn::os::ProcessId id) NN_NOEXCEPT;
        nn::Result TerminateProgram(nn::ncm::ProgramId id) NN_NOEXCEPT;
        nn::Result GetProcessEventHandle(nn::svc::Handle* pOut) NN_NOEXCEPT;
        nn::Result GetProcessEventInfo(nn::pm::ProcessEventInfo* pOut) NN_NOEXCEPT;
        nn::Result GetExceptionProcessIdList(int* pStoredCount, os::ProcessId* pBuffer, int bufferEntryCount) NN_NOEXCEPT;
        nn::Result StartProcess(os::ProcessId id) NN_NOEXCEPT;
        nn::Result GetProcessId(os::ProcessId* pOut, ncm::ProgramId programId) NN_NOEXCEPT;
        nn::Result GetApplicationProcessId(os::ProcessId* pOut) NN_NOEXCEPT;
        nn::Result HookToCreateProcess(os::NativeHandle* pOut, ncm::ProgramId programId) NN_NOEXCEPT;
        nn::Result HookToCreateApplicationProcess(os::NativeHandle* pOut) NN_NOEXCEPT;
        nn::Result ClearHook(int hookTypes) NN_NOEXCEPT;
        nn::Result GetProgramId(ncm::ProgramId* pOut, nn::os::ProcessId id) NN_NOEXCEPT;
        nn::Result BoostSystemMemoryResourceLimit(int64_t boostSize) NN_NOEXCEPT;
        void NotifyBootFinished() NN_NOEXCEPT;

    private:
        ProcessManager() NN_NOEXCEPT
        {
        }

    public:
        static void Initialize() NN_NOEXCEPT;
        static ProcessManager* GetInstance() NN_NOEXCEPT
        {
            return g_pInstance;
        }

    private:
        static ProcessManager* g_pInstance;
    };

}}  // namespace nn::pm
