﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Result.h>
#include <nn/sf/sf_HipcServer.h>
#include <nn/sf/sf_NativeHandle.h>
#include <nn/pm/pm_Result.h>
#include "pm_ProcessManager.h"
#include <climits>

namespace nn { namespace pm {

    class DebugMonitorInterfaceServer
    {
    public:
        nn::Result GetExceptionProcessIdList(nn::sf::Out<int> storedCount, const nn::sf::OutBuffer& buffer) NN_NOEXCEPT
        {
            if (buffer.GetSize() / sizeof(os::ProcessId) > INT_MAX)
            {
                return nn::pm::ResultInvalidSize();
            }
            return ProcessManager::GetInstance()->GetExceptionProcessIdList(
                    storedCount.GetPointer(),
                    reinterpret_cast<os::ProcessId*>(buffer.GetPointerUnsafe()),
                    buffer.GetSize() / sizeof(os::ProcessId));
        }
        nn::Result StartProcess(nn::os::ProcessId id) NN_NOEXCEPT
        {
            return ProcessManager::GetInstance()->StartProcess(id);
        }
        nn::Result GetProcessId(nn::sf::Out<nn::os::ProcessId> out, const ncm::ProgramId programId) NN_NOEXCEPT
        {
            return ProcessManager::GetInstance()->GetProcessId(out.GetPointer(), programId);
        }
        nn::Result GetApplicationProcessId(nn::sf::Out<nn::os::ProcessId> out) NN_NOEXCEPT
        {
            return ProcessManager::GetInstance()->GetApplicationProcessId(out.GetPointer());
        }
        nn::Result HookToCreateProcess(nn::sf::Out<nn::sf::NativeHandle> eventHandle, nn::ncm::ProgramId programId) NN_NOEXCEPT
        {
            os::NativeHandle handle;
            auto r = ProcessManager::GetInstance()->HookToCreateProcess(&handle, programId);
            eventHandle.Set(sf::NativeHandle(handle, false));
            return r;
        }
        nn::Result HookToCreateApplicationProcess(nn::sf::Out<nn::sf::NativeHandle> eventHandle) NN_NOEXCEPT
        {
            os::NativeHandle handle;
            auto r = ProcessManager::GetInstance()->HookToCreateApplicationProcess(&handle);
            eventHandle.Set(sf::NativeHandle(handle, false));
            return r;
        }
        nn::Result ClearHook(int hookTypes) NN_NOEXCEPT
        {
            return ProcessManager::GetInstance()->ClearHook(hookTypes);
        }
    };

}}  // namespace nn::pm

