﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/pm/pm_BootModeApi.h>
#include <nn/pm/detail/pm_BootModeInterface.h>

namespace nn { namespace pm {

    class BootModeManager
    {
#if defined(NN_PM_BUILD_TYPE_SAFE_MODE)
        const BootMode DefaultBootMode = BootMode_SafeMode;
#else
        const BootMode DefaultBootMode = BootMode_Normal;
#endif

    public:
        BootModeManager() : m_BootMode(DefaultBootMode) {}
        Result GetBootMode(sf::Out<Bit32> outValue) NN_NOEXCEPT;
        Result SetMaintenanceBoot() NN_NOEXCEPT;
        Result SetSafeModeBoot() NN_NOEXCEPT;

    private:
        BootMode m_BootMode;
    };

}}  // namespace nn::pm
