﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Result.h>
#include <nn/ncm/ncm_ProgramId.h>

namespace nn { namespace ldr {

    class ArgumentStore
    {
    public:
        static const size_t ArgumentBufferSize = 32 * 1024;

        struct Entry
        {
            ncm::ProgramId programId;
            size_t argumentSize;
            Bit8 argument[ArgumentBufferSize];
        };

    public:
        const Entry* Get(ncm::ProgramId programId) NN_NOEXCEPT;
        nn::Result Set(ncm::ProgramId programId, const void* pArgument, size_t size) NN_NOEXCEPT;
        nn::Result Flush() NN_NOEXCEPT;

    private:
        static const int ArgumentMapCount = 10;

    private:
        static int FindIndex(Entry* pMap, ncm::ProgramId programId) NN_NOEXCEPT;

    private:
        Entry   m_ArgumentMap[ArgumentMapCount];
    };

}}  // namespace nn::ldr
