﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Abort.h>

#include <nn/os.h>

#include <nn/spl/spl_Api.h>
#include <nn/spl/spl_Result.h>
#include <nn/spl/spl_Types.h>

/**
 * @flie spl 非対応ハードウェアで用いるスタブ
 */

namespace nn { namespace spl {

    void Initialize() NN_NOEXCEPT
    {
    }

    void InitializeForFs() NN_NOEXCEPT
    {
    }

    void Finalize() NN_NOEXCEPT
    {
    }

    Result GetConfig(
        Bit64*      pOut,
        ConfigItem  key ) NN_NOEXCEPT
    {
        switch (key)
        {
        case ConfigItem_IsDevelopmentFunctionEnabled:
            *pOut = 1;
            break;
        case ConfigItem_DeviceUniqueKeyGeneration:
            *pOut = 0;
            break;
        default:
            NN_ABORT("ConfigItem (%d) is unknown or default value is not defined.\n", static_cast<int>(key));
        }
        return ResultSuccess();
    }

    Result ModularExponentiate(
        void*       pResultBuffer,
        size_t      resultBufferSize,
        const void* pBase,
        size_t      baseSize,
        const void* pExponent,
        size_t      exponentSize,
        const void* pModulus,
        size_t      modulusSize ) NN_NOEXCEPT
    {
        NN_UNUSED(pResultBuffer);
        NN_UNUSED(resultBufferSize);
        NN_UNUSED(pBase);
        NN_UNUSED(baseSize);
        NN_UNUSED(pExponent);
        NN_UNUSED(exponentSize);
        NN_UNUSED(pModulus);
        NN_UNUSED(modulusSize);
        NN_ABORT("nn::spl::%s() is not implemented.\n", __FUNCTION__);
    }

    Result AllocateAesKeySlot(
        int* pSlotIndex ) NN_NOEXCEPT
    {
        // 常に 0 を返す
        *pSlotIndex = 0;

        return ResultSuccess();
    }

    Result DeallocateAesKeySlot(
        int slotIndex ) NN_NOEXCEPT
    {
        NN_UNUSED(slotIndex);
        NN_ABORT("nn::spl::%s() is not implemented.\n", __FUNCTION__);
    }

    Result GenerateAesKek(
        AccessKey*          pAccessKey,
        const void*         pKeySource,
        size_t              keySourceSize,
        int                 generation,
        int                 option ) NN_NOEXCEPT
    {
        NN_UNUSED(pKeySource);
        NN_UNUSED(keySourceSize);
        NN_UNUSED(generation);
        NN_UNUSED(option);

        // 常に 0 を返す
        std::memset(pAccessKey, 0, sizeof(*pAccessKey));

        return ResultSuccess();
    }

    Result LoadAesKey(
        int                 slotIndex,
        const AccessKey&    accessKey,
        const void*         pKeySource,
        size_t              keySourceSize ) NN_NOEXCEPT
    {
        NN_UNUSED(slotIndex);
        NN_UNUSED(accessKey);
        NN_UNUSED(pKeySource);
        NN_UNUSED(keySourceSize);

        // 何もしない
        return ResultSuccess();
    }

    Result GenerateAesKey(
        void*               pOutBuffer,
        size_t              outBufferSize,
        const AccessKey&    accessKey,
        const void*         pKeySource,
        size_t              keySourceSize ) NN_NOEXCEPT
    {
        NN_UNUSED(accessKey);
        NN_UNUSED(pKeySource);
        NN_UNUSED(keySourceSize);

        // 常に 0 を返す
        std::memset(pOutBuffer, 0, outBufferSize);

        return ResultSuccess();
    }

    Result GenerateSpecificAesKey(
        void*       pOutBuffer,
        size_t      outBufferSize,
        const void* pSource,
        size_t      sourceSize,
        int         generation,
        Bit32       purpose  ) NN_NOEXCEPT
    {
        NN_UNUSED(pOutBuffer);
        NN_UNUSED(outBufferSize);
        NN_UNUSED(pSource);
        NN_UNUSED(sourceSize);
        NN_UNUSED(generation);
        NN_UNUSED(purpose);
        NN_ABORT("nn::spl::%s() is not implemented.\n", __FUNCTION__);
    }

    Result ComputeCtr(
        void*       pOutBuffer,
        size_t      outBufferSize,
        int         slotIndex,
        const void* pInBuffer,
        size_t      inBufferSize,
        const void* pInitialCounter,
        size_t      initialCounterSize ) NN_NOEXCEPT
    {
        NN_UNUSED(pOutBuffer);
        NN_UNUSED(outBufferSize);
        NN_UNUSED(slotIndex);
        NN_UNUSED(inBufferSize);
        NN_UNUSED(pInitialCounter);
        NN_UNUSED(initialCounterSize);
        NN_ABORT("nn::spl::%s() is not implemented.\n", __FUNCTION__);
    }

    Result ComputeCmac(
        void*       pOutBuffer,
        size_t      outBufferSize,
        int         slotIndex,
        const void* pInBuffer,
        size_t      inBufferSize ) NN_NOEXCEPT
    {
        NN_UNUSED(slotIndex);
        NN_UNUSED(pInBuffer);
        NN_UNUSED(inBufferSize);

        // 常に 0 を返す
        std::memset(pOutBuffer, 0, outBufferSize);

        return ResultSuccess();
    }

    Result ExtractDrmDeviceCertEccKey(
        void*                pOutBuffer,
        size_t               outBufferSize,
        const void*          pData,
        size_t               dataSize ) NN_NOEXCEPT
    {
        NN_UNUSED(pOutBuffer);
        NN_UNUSED(outBufferSize);
        NN_UNUSED(pData);
        NN_UNUSED(dataSize);
        NN_ABORT("nn::spl::%s() is not implemented.\n", __FUNCTION__);
    }

    Result ExtractSslClientCertKey(
        void*                pOutBuffer,
        size_t               outBufferSize,
        const void*          pData,
        size_t               dataSize ) NN_NOEXCEPT
    {
        NN_UNUSED(pOutBuffer);
        NN_UNUSED(outBufferSize);
        NN_UNUSED(pData);
        NN_UNUSED(dataSize);
        NN_ABORT("nn::spl::%s() is not implemented.\n", __FUNCTION__);
    }

    Result DecryptAesKey(
        void*       pOutBuffer,
        size_t      outBufferSize,
        const void* pSource,
        size_t      sourceSize,
        int         generation,
        Bit32       option) NN_NOEXCEPT
    {
        NN_UNUSED(pOutBuffer);
        NN_UNUSED(outBufferSize);
        NN_UNUSED(pSource);
        NN_UNUSED(sourceSize);
        NN_UNUSED(generation);
        NN_UNUSED(option);
        NN_ABORT("nn::spl::%s() is not implemented.\n", __FUNCTION__);
    }

    Result SetConfig(
        ConfigItem  key,
        Bit64       value ) NN_NOEXCEPT
    {
        NN_UNUSED(key);
        NN_UNUSED(value);
        NN_ABORT("nn::spl::%s() is not implemented.\n", __FUNCTION__);
    }

    bool IsDevelopment() NN_NOEXCEPT
    {
        return true;
    }

    SocType GetSocType() NN_NOEXCEPT
    {
        NN_ABORT("nn::spl::%s() is not implemented.\n", __FUNCTION__);
    }

    Result GetPackage2Hash(
        void*       pOutBuffer,
        size_t      bufferSize) NN_NOEXCEPT
    {
        NN_UNUSED(pOutBuffer);
        NN_UNUSED(bufferSize);
        NN_ABORT("nn::spl::%s() is not implemented.\n", __FUNCTION__);
    }

    Result  GenerateRandomBytes(
        void*   pOutBuffer,
        size_t  bufferSize ) NN_NOEXCEPT
    {
        // tick 値を返す
        auto value = static_cast<int>(nn::os::GetSystemTick().GetInt64Value());
        std::memset(pOutBuffer, value, bufferSize);
        return ResultSuccess();
    }

    Result  DecryptAndStoreGcKey(
        const void* pData,
        size_t      dataSize ) NN_NOEXCEPT
    {
        NN_UNUSED(pData);
        NN_UNUSED(dataSize);
        NN_ABORT("nn::spl::%s() is not implemented.\n", __FUNCTION__);
    }

    Result  DecryptGcMessage(
        size_t*     pOutResultSize,
        void*       pResultBuffer,
        size_t      resultBufferSize,
        const void* pCipher,
        size_t      cipherSize,
        const void* pModulus,
        size_t      modulusSize,
        const void* pLabelDigest,
        size_t      labelDigestSize) NN_NOEXCEPT
    {
        NN_UNUSED(pOutResultSize);
        NN_UNUSED(pResultBuffer);
        NN_UNUSED(resultBufferSize);
        NN_UNUSED(pCipher);
        NN_UNUSED(cipherSize);
        NN_UNUSED(pModulus);
        NN_UNUSED(modulusSize);
        NN_UNUSED(pLabelDigest);
        NN_UNUSED(labelDigestSize);
        NN_ABORT("nn::spl::%s() is not implemented.\n", __FUNCTION__);
    }

    Result LoadEsDeviceKey(
        const void*      pData,
        size_t           dataSize ) NN_NOEXCEPT
    {
        NN_UNUSED(pData);
        NN_UNUSED(dataSize);
        NN_ABORT("nn::spl::%s() is not implemented.\n", __FUNCTION__);
    }

    Result PrepareEsTitleKey(
        AccessKey*       pAccessKey,
        const void*      pCipher,
        size_t           cipherSize,
        const void*      pModulus,
        size_t           modulusSize,
        const void*      pLabelDigest,
        size_t           labelDigestSize,
        int              generation) NN_NOEXCEPT
    {
        NN_UNUSED(pAccessKey);
        NN_UNUSED(pCipher);
        NN_UNUSED(cipherSize);
        NN_UNUSED(pModulus);
        NN_UNUSED(modulusSize);
        NN_UNUSED(pLabelDigest);
        NN_UNUSED(labelDigestSize);
        NN_UNUSED(generation);
        NN_ABORT("nn::spl::%s() is not implemented.\n", __FUNCTION__);
    }

    Result PrepareCommonEsTitleKey(
        AccessKey*       pAccessKey,
        const void*      pKeySource,
        size_t           keySourceSize,
        int              generation) NN_NOEXCEPT
    {
        NN_UNUSED(pAccessKey);
        NN_UNUSED(pKeySource);
        NN_UNUSED(keySourceSize);
        NN_UNUSED(generation);
        NN_ABORT("nn::spl::%s() is not implemented.\n", __FUNCTION__);
    }

    Result LoadPreparedAesKey(
        int              slotIndex,
        const AccessKey& accessKey) NN_NOEXCEPT
    {
        NN_UNUSED(slotIndex);
        NN_UNUSED(accessKey);
        NN_ABORT("nn::spl::%s() is not implemented.\n", __FUNCTION__);
    }

    Result SetBootReason(BootReasonValue bootReason) NN_NOEXCEPT
    {
        NN_UNUSED(bootReason);
        NN_ABORT("nn::spl::%s() is not implemented.\n", __FUNCTION__);
    }

    Result GetBootReason(BootReasonValue* pOut) NN_NOEXCEPT
    {
        NN_UNUSED(pOut);
        NN_ABORT("nn::spl::%s() is not implemented.\n", __FUNCTION__);
    }

}}  // namespace nn::spl
