﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <cstring>

#include <nn/nn_Result.h>
#include <nn/nn_SdkAssert.h>

#include <nn/tsc/tsc_Result.h>
#include <nn/tsc/tsc_Types.h>
#include <nn/tsc/tsc_ConfigContexts.h>
#include <nn/tsc/tsc_ActiveConfigContext.h>

#include "tsc_Util.h"
#include "tsc_TcpipStackConfigBase.h"

namespace nn { namespace tsc { namespace detail {
/*
 * Virtual interface
 */
Result TcpIpStackConfigBase::Initialize()
{
    return nn::ResultSuccess();
}

Result TcpIpStackConfigBase::Finalize()
{
    return nn::ResultSuccess();
}

Result TcpIpStackConfigBase::ApplyIpConfig(Ipv4ConfigContext* pInContext, int modeMask)
{
    return nn::ResultSuccess();
}

Result TcpIpStackConfigBase::CleanupConfigContext(const Ipv4ConfigContext* pInContext)
{
    return nn::ResultSuccess();
}

Result TcpIpStackConfigBase::CancelApplyIpConfig()
{
    return nn::ResultSuccess();
}

Result TcpIpStackConfigBase::CheckDuplicateIp(int msecTimeout)
{
    return nn::ResultSuccess();
}

Result TcpIpStackConfigBase::NotifyInterfaceDown(const char* pInInterfaceName)
{
    return nn::ResultSuccess();
}

Result TcpIpStackConfigBase::GetInterfaceStatistics(
    const char* pInInterfaceName,
    ActiveConfigContext::InterfaceStatistics* pOutStats)
{
    return nn::ResultSuccess();
}
}}}
