﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Result.h>
#include <nn/nn_SdkAssert.h>

#include <nn/tsc/tsc_Result.h>
#include <nn/tsc/tsc_Types.h>
#include "tsc_TcpipStackConfigBase.h"
#include "tsc_TcpipStackConfigBsd.h"

#include "tsc_Util.h"

namespace nn { namespace tsc {

class detail::TcpIpStackConfigBase* g_pObjStackConfig = nullptr;
nn::os::Mutex g_initMutex(false);

#ifdef NN_NETWORK_USE_BSDSOCKET
class detail::TcpIpStackConfigBsd g_ObjBsdStackConfig;
#endif

Result Initialize() NN_NOEXCEPT
{
    Result result;
    detail::TcpIpStackConfigBase* pTempConfigObj = nullptr;
    detail::ScopedMutexLock mutexLock(g_initMutex);

    NN_DETAIL_TSC_RETURN_ON_INITIALIZED_STATE();

#ifdef NN_NETWORK_USE_BSDSOCKET
    pTempConfigObj = &g_ObjBsdStackConfig;
#endif

    result = pTempConfigObj->Initialize();
    if(result.IsFailure())
    {
        return result;
    }

    g_pObjStackConfig = pTempConfigObj;
    return nn::ResultSuccess();
}

Result Finalize() NN_NOEXCEPT
{
    detail::ScopedMutexLock mutexLock(g_initMutex);

    NN_DETAIL_TSC_RETURN_ON_UNINITIALIZED_STATE();

    nn::Result result = g_pObjStackConfig->Finalize();
    if(result .IsFailure())
    {
        return result;
    }
    g_pObjStackConfig = nullptr;

    return nn::ResultSuccess();
}
}}
