﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <cstdio>
#include <cstring>
#include <nn/nn_Result.h>
#include <nn/nn_SdkAssert.h>
#include <nn/socket.h>
#include <nn/tsc/tsc_Result.h>
#include <nn/tsc/tsc_Types.h>
#include "tsc_Util.h"

//TODO: This code should not be included in the product

namespace nn { namespace tsc { namespace debug {
    char* GetStringFromNetworkAddress(Ipv4AddrStorage networkAddress) NN_NOEXCEPT
    {
        static char s_UnsafeAddressString[16];
        memset(s_UnsafeAddressString, 0x00, sizeof(s_UnsafeAddressString));
        snprintf(s_UnsafeAddressString, 16, "%d.%d.%d.%d",
            ((networkAddress.storage<<24)>>24), ((networkAddress.storage<<16)>>24),
            ((networkAddress.storage<<8)>>24), (networkAddress.storage>>24));
        return s_UnsafeAddressString;
    }

    void DumpIpAddressInfo(const Ipv4Config *pIpConfig) NN_NOEXCEPT
    {
        NN_SDK_LOG(" Interface address :%s\n", GetStringFromNetworkAddress(pIpConfig->interfaceAddress));
        NN_SDK_LOG(" Subnet mask       :%s\n", GetStringFromNetworkAddress(pIpConfig->subnetMask));
        NN_SDK_LOG(" Default gatewy    :%s\n", GetStringFromNetworkAddress(pIpConfig->defaultGateway));
        NN_SDK_LOG(" Preferred DNS     :%s\n", GetStringFromNetworkAddress(pIpConfig->preferredDns));
        NN_SDK_LOG(" Alternative DNS   :%s\n", GetStringFromNetworkAddress(pIpConfig->alternativeDns));
    }

    void SetAddressFromString(const char* pInString, Ipv4AddrStorage* pOutAddress) NN_NOEXCEPT
    {
        nn::socket::InetPton(nn::socket::Family::Af_Inet, pInString, reinterpret_cast<void*>(pOutAddress));
    }

    const char* GetErrorReasonString(nn::Result tscResult) NN_NOEXCEPT
    {
        if(nn::tsc::ResultNullPointer::Includes(tscResult))
        {
            return "Passed pointer is invalid";
        }
        else if(nn::tsc::ResultInterfaceNameInvalid::Includes(tscResult))
        {
            return "Invalid interface name is set";
        }
        else if(nn::tsc::ResultIpv4ConfigMethodInvalid::Includes(tscResult))
        {
            return "Passed IPv4 configuration method is invalid";
        }
        else if(nn::tsc::ResultIpv4AddressInvalid::Includes(tscResult))
        {
            return "Passed IPv4 interface address is invalid";
        }
        else if(nn::tsc::ResultIpv4SubnetMaskInvalid::Includes(tscResult))
        {
            return "Passed subnet mask is invalid";
        }
        else if(nn::tsc::ResultIpv4DefaultGatewayInvalid::Includes(tscResult))
        {
            return "Passed gateway address is invalid";
        }
        else if(nn::tsc::ResultIpv4PreferredDnsInvalid::Includes(tscResult))
        {
            return "Passed preferred DNS address is invalid";
        }
        else if(nn::tsc::ResultIpv4AlternativeDnsInvalid::Includes(tscResult))
        {
            return "Passed alternative DNS address is invalid";
        }
        else if(nn::tsc::ResultMtuInvalid::Includes(tscResult))
        {
            return "Passed MTU value is invalid";
        }
        else if(nn::tsc::ResultContextInvalid::Includes(tscResult))
        {
            return "Passed context is invalid";
        }
        else if(nn::tsc::ResultLibraryNotInitialized::Includes(tscResult))
        {
            return "TSC library is not initialized yet";
        }
        else if(nn::tsc::ResultConfigurationInProgress::Includes(tscResult))
        {
            return "TSC library is currently in the process of configuring IP information";
        }
        else if(nn::tsc::ResultInterfaceNotReady::Includes(tscResult))
        {
            return "Network is not ready on specified network interface";
        }
        else if(nn::tsc::ResultProcessAborted::Includes(tscResult))
        {
            return "Operation aborted";
        }
        else if(nn::tsc::ResultProcessTimeout::Includes(tscResult))
        {
            return "Operation timeout";
        }
        else if(nn::tsc::ResultProcessAlreadyDone::Includes(tscResult))
        {
            return "Operation is already done";
        }
        else if(nn::tsc::ResultNoContext::Includes(tscResult))
        {
            return "No context was found to clear";
        }
        else if(nn::tsc::ResultInternalModuleFailed::Includes(tscResult))
        {
            return "Process failed due to mandatory internal module error";
        }
        else if(nn::tsc::ResultInvalidInternalLogic::Includes(tscResult))
        {
            return "Fatal error in TSC library";
        }
        else
        {
            return "Unkown error passd";
        }
    }
}}}
