﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using nn;
using nn.sf;
using Nintendo.ServiceFramework;
using Nintendo.ServiceFramework.CppCode;
using Nintendo.ServiceFramework.Hipc;
using std;

namespace nn.htcs
{
    [CppRefPath(@"<nn/htcs/htcs_Types.h>")]
    [ExternalStruct(66, 2)]
    public struct SockAddrHtcs
    {
    }

    [CppRefPath(@"<nn/htcs/htcs_Types.h>")]
    [ExternalStruct(32, 2)]
    public struct HtcsPeerName
    {
    }
}

namespace nn.tma
{
    [CppRefPath(@"<nn/tma/tma_IHtcsManager.sfdl.h>")]
    public interface IHtcsManager : IServiceObject
    {
        [MethodId(0)]
        Result Socket         ( Out<int32_t>    pOutErrorCode,
                                Out<int32_t>    pOutSocket );

        [MethodId(1)]
        Result Close          ( Out<int32_t>    pOutErrorCode,
                                Out<int32_t>    pOutIntResult,
                                int32_t         descriptor );

        [MethodId(2)]
        Result Connect        ( Out<int32_t>    pOutErrorCode,
                                Out<int32_t>    pOutIntResult,
                                int32_t         descriptor,
                                htcs.SockAddrHtcs address);

        [MethodId(3)]
        Result Bind           ( Out<int32_t>    pOutErrorCode,
                                Out<int32_t>    pOutIntResult,
                                int32_t         descriptor,
                                htcs.SockAddrHtcs address);

        [MethodId(4)]
        Result Listen         ( Out<int32_t>    pOutErrorCode,
                                Out<int32_t>    pOutIntResult,
                                int32_t         descriptor,
                                int32_t         backlogCount );

        [MethodId(5)]
        Result Accept         ( Out<int32_t>    pOutErrorCode,
                                Out<int32_t>    pOutIntResult,
                                Out<htcs.SockAddrHtcs> pOutAddress,
                                int32_t         descriptor );


        [MethodId(6)]
        Result Recv           ( Out<int32_t>    pOutErrorCode,
                                Out<int64_t>    pOutReceivedSize,
                                OutBuffer       buffer,
                                int32_t         descriptor,
                                int32_t         flags );


        [MethodId(7)]
        Result Send           ( Out<int32_t>    pOutErrorCode,
                                Out<int64_t>    pOutSentSize,
                                int32_t         descriptor,
                                InBuffer        buffer,
                                int32_t         flags );

        [MethodId(8)]
        Result Shutdown       ( Out<int32_t>    pOutErrorCode,
                                Out<int32_t>    pOutIntResult,
                                int32_t         descriptor,
                                int32_t         how );

        [MethodId(9)]
        Result Fcntl          ( Out<int32_t>    pOutErrorCode,
                                Out<int32_t>    pOutIntResult,
                                int32_t         descriptor,
                                int32_t         command,
                                int32_t         value );
        [MethodId(10)]
        Result GetPeerNameAny ( Out<htcs.HtcsPeerName> pOutValue );

        [MethodId(11)]
        Result GetDefaultHostName ( Out<htcs.HtcsPeerName> pOutValue );

        [MethodId(12)]
        Result CreateSocketOld (Out<int32_t> pOutErrorCode,
                                Out<ISocket> pOutSocket);

        [MethodId(13)]
        Result CreateSocket   (Out<int32_t> pOutErrorCode,
                               Out<ISocket> pOutSocket,
                               bool enableDisconnectionEmulation);

        [MethodId(100)]
        Result RegisterProcessId([ProcessId] Bit64 processId);

        [MethodId(101)]
        Result MonitorManager([ProcessId] Bit64 processId);
    }

    [CppRefPath(@"<nn/tma/tma_IHtcsManager.sfdl.h>")]
    public interface ISocket : IServiceObject
    {
        [MethodId(0)]
        Result Close          (Out<int32_t> pOutErrorCode,
                               Out<int32_t> pOutIntResult);

        [MethodId(1)]
        Result Connect        (Out<int32_t> pOutErrorCode,
                               Out<int32_t> pOutIntResult,
                               htcs.SockAddrHtcs address);

        [MethodId(2)]
        Result Bind           (Out<int32_t> pOutErrorCode,
                               Out<int32_t> pOutIntResult,
                               htcs.SockAddrHtcs address);

        [MethodId(3)]
        Result Listen         (Out<int32_t> pOutErrorCode,
                               Out<int32_t> pOutIntResult,
                               int32_t backlogCount);

        [MethodId( 4 )]
        Result Accept         ( Out<int32_t> pOutErrorCode,
                               Out<ISocket> pOutSocket,
                               Out<htcs.SockAddrHtcs> pOutAddress );

        [MethodId( 5 )]
        Result Recv           ( Out<int32_t> pOutErrorCode,
                               Out<int64_t> pOutReceivedSize,
                               [AutoSelectBuffer] OutBuffer buffer,
                               int32_t flags );

        [MethodId( 6 )]
        Result Send           ( Out<int32_t> pOutErrorCode,
                               Out<int64_t> pOutSentSize,
                               [AutoSelectBuffer] InBuffer buffer,
                               int32_t flags );

        [MethodId(7)]
        Result Shutdown       (Out<int32_t> pOutErrorCode,
                               Out<int32_t> pOutIntResult,
                               int32_t how);

        [MethodId(8)]
        Result Fcntl          (Out<int32_t> pOutErrorCode,
                               Out<int32_t> pOutIntResult,
                               int32_t command,
                               int32_t value);

        [MethodId( 9 )]
        Result AcceptStart( Out<uint32_t> pTaskId,
                               Out<NativeHandle> pWaitHandle );

        [MethodId( 10 )]
        Result AcceptResults( Out<int32_t> pOutErrorCode,
                               Out<ISocket> pOutSocket,
                               Out<htcs.SockAddrHtcs> pOutAddress,
                               uint32_t TaskId );


        [MethodId( 11 )]
        Result RecvStart     ( Out<uint32_t> pTaskId,
                                Out<NativeHandle> pWaitHandle,
                                int32_t memorySize,
                                int32_t flags );

        [MethodId( 12 )]
        Result RecvResults    ( Out<int32_t> pOutErrorCode,
                                Out<int64_t> pOutReceivedSize,
                                [AutoSelectBuffer] OutBuffer buffer,
                                uint32_t TaskId );

        [MethodId( 13 )]
        Result RecvLargeStart ( Out<uint32_t> pTaskId,
                                Out<NativeHandle> pWaitHandle,
                                int32_t unalignedRecvSizeStart,
                                int32_t unalignedRecvSizeEnd,
                                int64_t alignedSendSize,
                                NativeHandle alignedMemoryHandle,
                                int32_t flags );

        [MethodId( 14 )]
        Result SendStart      ( Out<uint32_t> pTaskId,
                                Out<NativeHandle> pWaitHandle,
                                [AutoSelectBuffer] InBuffer buffer,
                                int32_t flags );

        [MethodId( 15 )]
        Result SendLargeStart( Out<uint32_t> pTaskId,
                                Out<NativeHandle> pWaitHandle,
                                [AutoSelectBuffer] InBuffer startBuffer,
                                [AutoSelectBuffer] InBuffer endBuffer,
                                NativeHandle alignedMemoryHandle,
                                int64_t alignedSendSize,
                                int32_t flags );

        [MethodId( 16 )]
        Result SendResults  ( Out<int32_t> pOutErrorCode,
                                Out<int64_t> pOutSentSize,
                                uint32_t TaskId );

    }
}
