﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/*
 * このファイルを編集しないでください。
 * このファイルは自動生成されます。
 */

#include <nn/svc/svc_ServerId.autogen.h>


//-------------------------------------------------
// Result CreateSession(nn::svc::Handle* pServerSession, nn::svc::Handle* pClientSession, bool isLight, uintptr_t name)
//
//     AArch64 s=8 r=8 p=4                 Invariant s=8 r=8 p=8
// in  abi                                 svc
//     Register 0  ref  4 pServerSession   
//     Register 1  ref  4 pClientSession   
//     Register 2       1 isLight          Register 2       1 isLight
//     Register 3       4 name             Register 3       8 name
//
// out abi                                 svc
//     Register 0       4 return           Register 0       4 return
//                                         Register 1       4 pServerSession
//                                         Register 2       4 pClientSession
//
// conversion
//   Scatter         pServerSession
//   Scatter         pClientSession

    .section .text._ZN2nn3svc7aarch645ilp3213CreateSessionEPNS0_6HandleES4_bm, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch645ilp3213CreateSessionEPNS0_6HandleES4_bm
    .hidden  _ZN2nn3svc7aarch645ilp3213CreateSessionEPNS0_6HandleES4_bm
    .type    _ZN2nn3svc7aarch645ilp3213CreateSessionEPNS0_6HandleES4_bm, %function
_ZN2nn3svc7aarch645ilp3213CreateSessionEPNS0_6HandleES4_bm:

    stp      x0, x1, [sp, #-16]!

    svc      #NN_SVC_ID_CREATE_SESSION

    ldr      x3, [sp, #0]              // pServerSessionのアドレス をスタックからレジスタへ
    str      w1, [x3, #0]              // pServerSession の第 1 ワードをレジスタからメモリへ
    ldr      x3, [sp, #8]              // pClientSessionのアドレス をスタックからレジスタへ
    str      w2, [x3, #0]              // pClientSession の第 1 ワードをレジスタからメモリへ

    add      sp, sp, #16
    ret

    .size _ZN2nn3svc7aarch645ilp3213CreateSessionEPNS0_6HandleES4_bm, [.-_ZN2nn3svc7aarch645ilp3213CreateSessionEPNS0_6HandleES4_bm]


//-------------------------------------------------
// Result AcceptSession(nn::svc::Handle* pOut, nn::svc::Handle port)
//
//     AArch64 s=8 r=8 p=4         Invariant s=8 r=8 p=8
// in  abi                         svc
//     Register 0  ref  4 pOut     
//     Register 1       4 port     Register 1       4 port
//
// out abi                         svc
//     Register 0       4 return   Register 0       4 return
//                                 Register 1       4 pOut
//
// conversion
//   Scatter         pOut

    .section .text._ZN2nn3svc7aarch645ilp3213AcceptSessionEPNS0_6HandleES3_, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch645ilp3213AcceptSessionEPNS0_6HandleES3_
    .hidden  _ZN2nn3svc7aarch645ilp3213AcceptSessionEPNS0_6HandleES3_
    .type    _ZN2nn3svc7aarch645ilp3213AcceptSessionEPNS0_6HandleES3_, %function
_ZN2nn3svc7aarch645ilp3213AcceptSessionEPNS0_6HandleES3_:

    str      x0, [sp, #-16]!

    svc      #NN_SVC_ID_ACCEPT_SESSION

    ldr      x2, [sp, #0]              // pOutのアドレス をスタックからレジスタへ
    str      w1, [x2, #0]              // pOut の第 1 ワードをレジスタからメモリへ

    add      sp, sp, #16
    ret

    .size _ZN2nn3svc7aarch645ilp3213AcceptSessionEPNS0_6HandleES3_, [.-_ZN2nn3svc7aarch645ilp3213AcceptSessionEPNS0_6HandleES3_]


//-------------------------------------------------
// Result ReplyAndReceiveLight(nn::svc::Handle session)
//
//     AArch64 s=8 r=8 p=4          Invariant s=8 r=8 p=8
// in  abi                          svc
//     Register 0       4 session   Register 0       4 session
//
// out abi                          svc
//     Register 0       4 return    Register 0       4 return
//
// conversion

    .section .text._ZN2nn3svc7aarch645ilp3220ReplyAndReceiveLightENS0_6HandleE, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch645ilp3220ReplyAndReceiveLightENS0_6HandleE
    .hidden  _ZN2nn3svc7aarch645ilp3220ReplyAndReceiveLightENS0_6HandleE
    .type    _ZN2nn3svc7aarch645ilp3220ReplyAndReceiveLightENS0_6HandleE, %function
_ZN2nn3svc7aarch645ilp3220ReplyAndReceiveLightENS0_6HandleE:

    svc      #NN_SVC_ID_REPLY_AND_RECEIVE_LIGHT
    ret

    .size _ZN2nn3svc7aarch645ilp3220ReplyAndReceiveLightENS0_6HandleE, [.-_ZN2nn3svc7aarch645ilp3220ReplyAndReceiveLightENS0_6HandleE]


//-------------------------------------------------
// Result ReplyAndReceive(int32_t* pIndex, const nn::svc::Handle pHandles[], int32_t numHandle, nn::svc::Handle replyTarget, int64_t ns)
//
//     AArch64 s=8 r=8 p=4              Invariant s=8 r=8 p=8
// in  abi                              svc
//     Register 0  ref  4 pIndex        
//     Register 1  ref -- pHandles      Register 1  ref -- pHandles
//     Register 2       4 numHandle     Register 2       4 numHandle
//     Register 3       4 replyTarget   Register 3       4 replyTarget
//     Register 4       8 ns            Register 4       8 ns
//
// out abi                              svc
//     Register 0       4 return        Register 0       4 return
//                                      Register 1       4 pIndex
//
// conversion
//   Scatter         pIndex

    .section .text._ZN2nn3svc7aarch645ilp3215ReplyAndReceiveEPiPKNS0_6HandleEiS4_x, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch645ilp3215ReplyAndReceiveEPiPKNS0_6HandleEiS4_x
    .hidden  _ZN2nn3svc7aarch645ilp3215ReplyAndReceiveEPiPKNS0_6HandleEiS4_x
    .type    _ZN2nn3svc7aarch645ilp3215ReplyAndReceiveEPiPKNS0_6HandleEiS4_x, %function
_ZN2nn3svc7aarch645ilp3215ReplyAndReceiveEPiPKNS0_6HandleEiS4_x:

    str      x0, [sp, #-16]!

    svc      #NN_SVC_ID_REPLY_AND_RECEIVE

    ldr      x2, [sp, #0]              // pIndexのアドレス をスタックからレジスタへ
    str      w1, [x2, #0]              // pIndex の第 1 ワードをレジスタからメモリへ

    add      sp, sp, #16
    ret

    .size _ZN2nn3svc7aarch645ilp3215ReplyAndReceiveEPiPKNS0_6HandleEiS4_x, [.-_ZN2nn3svc7aarch645ilp3215ReplyAndReceiveEPiPKNS0_6HandleEiS4_x]


//-------------------------------------------------
// Result ReplyAndReceiveWithUserBuffer(int32_t* pIndex, uintptr_t pMessage, size_t bufferSize, const nn::svc::Handle pHandles[], int32_t numHandle, nn::svc::Handle replyTarget, int64_t ns)
//
//     AArch64 s=8 r=8 p=4              Invariant s=8 r=8 p=8
// in  abi                              svc
//     Register 0  ref  4 pIndex        
//     Register 1       4 pMessage      Register 1       8 pMessage
//     Register 2       4 bufferSize    Register 2       8 bufferSize
//     Register 3  ref -- pHandles      Register 3  ref -- pHandles
//     Register 4       4 numHandle     Register 4       4 numHandle
//     Register 5       4 replyTarget   Register 5       4 replyTarget
//     Register 6       8 ns            Register 6       8 ns
//
// out abi                              svc
//     Register 0       4 return        Register 0       4 return
//                                      Register 1       4 pIndex
//
// conversion
//   Scatter         pIndex

    .section .text._ZN2nn3svc7aarch645ilp3229ReplyAndReceiveWithUserBufferEPimmPKNS0_6HandleEiS4_x, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch645ilp3229ReplyAndReceiveWithUserBufferEPimmPKNS0_6HandleEiS4_x
    .hidden  _ZN2nn3svc7aarch645ilp3229ReplyAndReceiveWithUserBufferEPimmPKNS0_6HandleEiS4_x
    .type    _ZN2nn3svc7aarch645ilp3229ReplyAndReceiveWithUserBufferEPimmPKNS0_6HandleEiS4_x, %function
_ZN2nn3svc7aarch645ilp3229ReplyAndReceiveWithUserBufferEPimmPKNS0_6HandleEiS4_x:

    str      x0, [sp, #-16]!

    svc      #NN_SVC_ID_REPLY_AND_RECEIVE_WITH_USER_BUFFER

    ldr      x2, [sp, #0]              // pIndexのアドレス をスタックからレジスタへ
    str      w1, [x2, #0]              // pIndex の第 1 ワードをレジスタからメモリへ

    add      sp, sp, #16
    ret

    .size _ZN2nn3svc7aarch645ilp3229ReplyAndReceiveWithUserBufferEPimmPKNS0_6HandleEiS4_x, [.-_ZN2nn3svc7aarch645ilp3229ReplyAndReceiveWithUserBufferEPimmPKNS0_6HandleEiS4_x]


//-------------------------------------------------
// Result CreateEvent(nn::svc::Handle* pWriteHandle, nn::svc::Handle* pReadHandle)
//
//     AArch64 s=8 r=8 p=4               Invariant s=8 r=8 p=8
// in  abi                               svc
//     Register 0  ref  4 pWriteHandle   
//     Register 1  ref  4 pReadHandle    
//
// out abi                               svc
//     Register 0       4 return         Register 0       4 return
//                                       Register 1       4 pWriteHandle
//                                       Register 2       4 pReadHandle
//
// conversion
//   Scatter         pWriteHandle
//   Scatter         pReadHandle

    .section .text._ZN2nn3svc7aarch645ilp3211CreateEventEPNS0_6HandleES4_, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch645ilp3211CreateEventEPNS0_6HandleES4_
    .hidden  _ZN2nn3svc7aarch645ilp3211CreateEventEPNS0_6HandleES4_
    .type    _ZN2nn3svc7aarch645ilp3211CreateEventEPNS0_6HandleES4_, %function
_ZN2nn3svc7aarch645ilp3211CreateEventEPNS0_6HandleES4_:

    stp      x0, x1, [sp, #-16]!

    svc      #NN_SVC_ID_CREATE_EVENT

    ldr      x3, [sp, #0]              // pWriteHandleのアドレス をスタックからレジスタへ
    str      w1, [x3, #0]              // pWriteHandle の第 1 ワードをレジスタからメモリへ
    ldr      x3, [sp, #8]              // pReadHandleのアドレス をスタックからレジスタへ
    str      w2, [x3, #0]              // pReadHandle の第 1 ワードをレジスタからメモリへ

    add      sp, sp, #16
    ret

    .size _ZN2nn3svc7aarch645ilp3211CreateEventEPNS0_6HandleES4_, [.-_ZN2nn3svc7aarch645ilp3211CreateEventEPNS0_6HandleES4_]


//-------------------------------------------------
// Result MapPhysicalMemoryUnsafe(uintptr_t addr, size_t size)
//
//     AArch64 s=8 r=8 p=4         Invariant s=8 r=8 p=8
// in  abi                         svc
//     Register 0       4 addr     Register 0       8 addr
//     Register 1       4 size     Register 1       8 size
//
// out abi                         svc
//     Register 0       4 return   Register 0       4 return
//
// conversion

    .section .text._ZN2nn3svc7aarch645ilp3223MapPhysicalMemoryUnsafeEmm, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch645ilp3223MapPhysicalMemoryUnsafeEmm
    .hidden  _ZN2nn3svc7aarch645ilp3223MapPhysicalMemoryUnsafeEmm
    .type    _ZN2nn3svc7aarch645ilp3223MapPhysicalMemoryUnsafeEmm, %function
_ZN2nn3svc7aarch645ilp3223MapPhysicalMemoryUnsafeEmm:

    svc      #NN_SVC_ID_MAP_PHYSICAL_MEMORY_UNSAFE
    ret

    .size _ZN2nn3svc7aarch645ilp3223MapPhysicalMemoryUnsafeEmm, [.-_ZN2nn3svc7aarch645ilp3223MapPhysicalMemoryUnsafeEmm]


//-------------------------------------------------
// Result UnmapPhysicalMemoryUnsafe(uintptr_t addr, size_t size)
//
//     AArch64 s=8 r=8 p=4         Invariant s=8 r=8 p=8
// in  abi                         svc
//     Register 0       4 addr     Register 0       8 addr
//     Register 1       4 size     Register 1       8 size
//
// out abi                         svc
//     Register 0       4 return   Register 0       4 return
//
// conversion

    .section .text._ZN2nn3svc7aarch645ilp3225UnmapPhysicalMemoryUnsafeEmm, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch645ilp3225UnmapPhysicalMemoryUnsafeEmm
    .hidden  _ZN2nn3svc7aarch645ilp3225UnmapPhysicalMemoryUnsafeEmm
    .type    _ZN2nn3svc7aarch645ilp3225UnmapPhysicalMemoryUnsafeEmm, %function
_ZN2nn3svc7aarch645ilp3225UnmapPhysicalMemoryUnsafeEmm:

    svc      #NN_SVC_ID_UNMAP_PHYSICAL_MEMORY_UNSAFE
    ret

    .size _ZN2nn3svc7aarch645ilp3225UnmapPhysicalMemoryUnsafeEmm, [.-_ZN2nn3svc7aarch645ilp3225UnmapPhysicalMemoryUnsafeEmm]


    .end

