﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/*
 * このファイルを編集しないでください。
 * このファイルは自動生成されます。
 */

#include <nn/svc/svc_DmntId.autogen.h>


//-------------------------------------------------
// Result GetDebugFutureThreadInfo(nn::svc::ilp32::LastThreadContext* pContext, nn::Bit64* threadId, nn::svc::Handle debug, int64_t ns)
//
//     AArch32 s=4 r=4 p=4           Invariant s=4 r=8 p=4
// in  abi                           svc
//     Register 0  ref 16 pContext   Register 0       8 ns
//     Register 1  ref  8 threadId   Register 1       8 ns
//     Register 2       4 debug      Register 2       4 debug
//     Stack    0       8 ns         
//     Stack    1       8 ns         
//
// out abi                           svc
//     Register 0       4 return     Register 0       4 return
//                                   Register 1      16 pContext
//                                   Register 2      16 pContext
//                                   Register 3      16 pContext
//                                   Register 4      16 pContext
//                                   Register 5       8 threadId
//                                   Register 6       8 threadId
//
// conversion
//   Load            ns
//   Load            ns
//   Scatter         pContext
//   Scatter         threadId

    .section .text._ZN2nn3svc7aarch3224GetDebugFutureThreadInfoEPNS0_5ilp3217LastThreadContextEPyNS0_6HandleEx, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch3224GetDebugFutureThreadInfoEPNS0_5ilp3217LastThreadContextEPyNS0_6HandleEx
    .hidden  _ZN2nn3svc7aarch3224GetDebugFutureThreadInfoEPNS0_5ilp3217LastThreadContextEPyNS0_6HandleEx
    .type    _ZN2nn3svc7aarch3224GetDebugFutureThreadInfoEPNS0_5ilp3217LastThreadContextEPyNS0_6HandleEx, %function
_ZN2nn3svc7aarch3224GetDebugFutureThreadInfoEPNS0_5ilp3217LastThreadContextEPyNS0_6HandleEx:

    push     {r0,r1,r4,r5,r6,r7}

    ldr      r0, [sp, #24]             // ns の値 をスタックからレジスタへ
    ldr      r1, [sp, #28]             // ns の値 をスタックからレジスタへ

    svc      #NN_SVC_ID_GET_DEBUG_FUTURE_THREAD_INFO

    ldr      r7, [sp, #0]              // pContextのアドレス をスタックからレジスタへ
    str      r1, [r7, #0]              // pContext の第 1 ワードをレジスタからメモリへ
    str      r2, [r7, #4]              // pContext の第 2 ワードをレジスタからメモリへ
    str      r3, [r7, #8]              // pContext の第 3 ワードをレジスタからメモリへ
    str      r4, [r7, #12]             // pContext の第 4 ワードをレジスタからメモリへ
    ldr      r7, [sp, #4]              // threadIdのアドレス をスタックからレジスタへ
    str      r5, [r7, #0]              // threadId の第 1 ワードをレジスタからメモリへ
    str      r6, [r7, #4]              // threadId の第 2 ワードをレジスタからメモリへ

    add      sp, sp, #8
    pop      {r4,r5,r6,r7}
    bx       lr

    .size _ZN2nn3svc7aarch3224GetDebugFutureThreadInfoEPNS0_5ilp3217LastThreadContextEPyNS0_6HandleEx, [.-_ZN2nn3svc7aarch3224GetDebugFutureThreadInfoEPNS0_5ilp3217LastThreadContextEPyNS0_6HandleEx]


//-------------------------------------------------
// Result DebugActiveProcess(nn::svc::Handle* pOut, nn::Bit64 processId)
//
//     AArch32 s=4 r=4 p=4            Invariant s=4 r=8 p=4
// in  abi                            svc
//     Register 0  ref  4 pOut        
//     Register 2       8 processId   Register 2       8 processId
//     Register 3       8 processId   Register 3       8 processId
//
// out abi                            svc
//     Register 0       4 return      Register 0       4 return
//                                    Register 1       4 pOut
//
// conversion
//   Scatter         pOut

    .section .text._ZN2nn3svc7aarch3218DebugActiveProcessEPNS0_6HandleEy, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch3218DebugActiveProcessEPNS0_6HandleEy
    .hidden  _ZN2nn3svc7aarch3218DebugActiveProcessEPNS0_6HandleEy
    .type    _ZN2nn3svc7aarch3218DebugActiveProcessEPNS0_6HandleEy, %function
_ZN2nn3svc7aarch3218DebugActiveProcessEPNS0_6HandleEy:

    push     {r0}

    svc      #NN_SVC_ID_DEBUG_ACTIVE_PROCESS

    ldr      r2, [sp, #0]              // pOutのアドレス をスタックからレジスタへ
    str      r1, [r2, #0]              // pOut の第 1 ワードをレジスタからメモリへ

    add      sp, sp, #4
    bx       lr

    .size _ZN2nn3svc7aarch3218DebugActiveProcessEPNS0_6HandleEy, [.-_ZN2nn3svc7aarch3218DebugActiveProcessEPNS0_6HandleEy]


//-------------------------------------------------
// Result BreakDebugProcess(nn::svc::Handle debug)
//
//     AArch32 s=4 r=4 p=4         Invariant s=4 r=8 p=4
// in  abi                         svc
//     Register 0       4 debug    Register 0       4 debug
//
// out abi                         svc
//     Register 0       4 return   Register 0       4 return
//
// conversion

    .section .text._ZN2nn3svc7aarch3217BreakDebugProcessENS0_6HandleE, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch3217BreakDebugProcessENS0_6HandleE
    .hidden  _ZN2nn3svc7aarch3217BreakDebugProcessENS0_6HandleE
    .type    _ZN2nn3svc7aarch3217BreakDebugProcessENS0_6HandleE, %function
_ZN2nn3svc7aarch3217BreakDebugProcessENS0_6HandleE:

    svc      #NN_SVC_ID_BREAK_DEBUG_PROCESS
    bx       lr

    .size _ZN2nn3svc7aarch3217BreakDebugProcessENS0_6HandleE, [.-_ZN2nn3svc7aarch3217BreakDebugProcessENS0_6HandleE]


//-------------------------------------------------
// Result TerminateDebugProcess(nn::svc::Handle debug)
//
//     AArch32 s=4 r=4 p=4         Invariant s=4 r=8 p=4
// in  abi                         svc
//     Register 0       4 debug    Register 0       4 debug
//
// out abi                         svc
//     Register 0       4 return   Register 0       4 return
//
// conversion

    .section .text._ZN2nn3svc7aarch3221TerminateDebugProcessENS0_6HandleE, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch3221TerminateDebugProcessENS0_6HandleE
    .hidden  _ZN2nn3svc7aarch3221TerminateDebugProcessENS0_6HandleE
    .type    _ZN2nn3svc7aarch3221TerminateDebugProcessENS0_6HandleE, %function
_ZN2nn3svc7aarch3221TerminateDebugProcessENS0_6HandleE:

    svc      #NN_SVC_ID_TERMINATE_DEBUG_PROCESS
    bx       lr

    .size _ZN2nn3svc7aarch3221TerminateDebugProcessENS0_6HandleE, [.-_ZN2nn3svc7aarch3221TerminateDebugProcessENS0_6HandleE]


//-------------------------------------------------
// Result GetDebugEvent(nn::svc::ilp32::DebugEventInfo* pInfo, nn::svc::Handle debug)
//
//     AArch32 s=4 r=4 p=4         Invariant s=4 r=8 p=4
// in  abi                         svc
//     Register 0  ref 56 pInfo    Register 0  ref 56 pInfo
//     Register 1       4 debug    Register 1       4 debug
//
// out abi                         svc
//     Register 0       4 return   Register 0       4 return
//
// conversion

    .section .text._ZN2nn3svc7aarch3213GetDebugEventEPNS0_5ilp3214DebugEventInfoENS0_6HandleE, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch3213GetDebugEventEPNS0_5ilp3214DebugEventInfoENS0_6HandleE
    .hidden  _ZN2nn3svc7aarch3213GetDebugEventEPNS0_5ilp3214DebugEventInfoENS0_6HandleE
    .type    _ZN2nn3svc7aarch3213GetDebugEventEPNS0_5ilp3214DebugEventInfoENS0_6HandleE, %function
_ZN2nn3svc7aarch3213GetDebugEventEPNS0_5ilp3214DebugEventInfoENS0_6HandleE:

    svc      #NN_SVC_ID_GET_DEBUG_EVENT
    bx       lr

    .size _ZN2nn3svc7aarch3213GetDebugEventEPNS0_5ilp3214DebugEventInfoENS0_6HandleE, [.-_ZN2nn3svc7aarch3213GetDebugEventEPNS0_5ilp3214DebugEventInfoENS0_6HandleE]


//-------------------------------------------------
// Result ContinueDebugEvent(nn::svc::Handle debug, nn::Bit32 flags, const nn::Bit64 pThreadIds[], int32_t arraySize)
//
//     AArch32 s=4 r=4 p=4             Invariant s=4 r=8 p=4
// in  abi                             svc
//     Register 0       4 debug        Register 0       4 debug
//     Register 1       4 flags        Register 1       4 flags
//     Register 2  ref -- pThreadIds   Register 2  ref -- pThreadIds
//     Register 3       4 arraySize    Register 3       4 arraySize
//
// out abi                             svc
//     Register 0       4 return       Register 0       4 return
//
// conversion

    .section .text._ZN2nn3svc7aarch3218ContinueDebugEventENS0_6HandleEjPKyi, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch3218ContinueDebugEventENS0_6HandleEjPKyi
    .hidden  _ZN2nn3svc7aarch3218ContinueDebugEventENS0_6HandleEjPKyi
    .type    _ZN2nn3svc7aarch3218ContinueDebugEventENS0_6HandleEjPKyi, %function
_ZN2nn3svc7aarch3218ContinueDebugEventENS0_6HandleEjPKyi:

    svc      #NN_SVC_ID_CONTINUE_DEBUG_EVENT
    bx       lr

    .size _ZN2nn3svc7aarch3218ContinueDebugEventENS0_6HandleEjPKyi, [.-_ZN2nn3svc7aarch3218ContinueDebugEventENS0_6HandleEjPKyi]


//-------------------------------------------------
// Result GetProcessList(int32_t* pNumProcesses, nn::Bit64 pProcessIds[], int32_t arraySize)
//
//     AArch32 s=4 r=4 p=4                Invariant s=4 r=8 p=4
// in  abi                                svc
//     Register 0  ref  4 pNumProcesses   
//     Register 1  ref -- pProcessIds     Register 1  ref -- pProcessIds
//     Register 2       4 arraySize       Register 2       4 arraySize
//
// out abi                                svc
//     Register 0       4 return          Register 0       4 return
//                                        Register 1       4 pNumProcesses
//
// conversion
//   Scatter         pNumProcesses

    .section .text._ZN2nn3svc7aarch3214GetProcessListEPiPyi, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch3214GetProcessListEPiPyi
    .hidden  _ZN2nn3svc7aarch3214GetProcessListEPiPyi
    .type    _ZN2nn3svc7aarch3214GetProcessListEPiPyi, %function
_ZN2nn3svc7aarch3214GetProcessListEPiPyi:

    push     {r0}

    svc      #NN_SVC_ID_GET_PROCESS_LIST

    ldr      r2, [sp, #0]              // pNumProcessesのアドレス をスタックからレジスタへ
    str      r1, [r2, #0]              // pNumProcesses の第 1 ワードをレジスタからメモリへ

    add      sp, sp, #4
    bx       lr

    .size _ZN2nn3svc7aarch3214GetProcessListEPiPyi, [.-_ZN2nn3svc7aarch3214GetProcessListEPiPyi]


//-------------------------------------------------
// Result GetThreadList(int32_t* pNumThreads, nn::Bit64 pThreadIds[], int32_t arraySize, nn::svc::Handle domain)
//
//     AArch32 s=4 r=4 p=4              Invariant s=4 r=8 p=4
// in  abi                              svc
//     Register 0  ref  4 pNumThreads   
//     Register 1  ref -- pThreadIds    Register 1  ref -- pThreadIds
//     Register 2       4 arraySize     Register 2       4 arraySize
//     Register 3       4 domain        Register 3       4 domain
//
// out abi                              svc
//     Register 0       4 return        Register 0       4 return
//                                      Register 1       4 pNumThreads
//
// conversion
//   Scatter         pNumThreads

    .section .text._ZN2nn3svc7aarch3213GetThreadListEPiPyiNS0_6HandleE, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch3213GetThreadListEPiPyiNS0_6HandleE
    .hidden  _ZN2nn3svc7aarch3213GetThreadListEPiPyiNS0_6HandleE
    .type    _ZN2nn3svc7aarch3213GetThreadListEPiPyiNS0_6HandleE, %function
_ZN2nn3svc7aarch3213GetThreadListEPiPyiNS0_6HandleE:

    push     {r0}

    svc      #NN_SVC_ID_GET_THREAD_LIST

    ldr      r2, [sp, #0]              // pNumThreadsのアドレス をスタックからレジスタへ
    str      r1, [r2, #0]              // pNumThreads の第 1 ワードをレジスタからメモリへ

    add      sp, sp, #4
    bx       lr

    .size _ZN2nn3svc7aarch3213GetThreadListEPiPyiNS0_6HandleE, [.-_ZN2nn3svc7aarch3213GetThreadListEPiPyiNS0_6HandleE]


//-------------------------------------------------
// Result GetDebugThreadContext(nn::svc::ThreadContext* pContext, nn::svc::Handle debug, nn::Bit64 threadId, nn::Bit32 controlFlags)
//
//     AArch32 s=4 r=4 p=4               Invariant s=4 r=8 p=4
// in  abi                               svc
//     Register 0  ref 332 pContext      Register 0  ref 332 pContext
//     Register 1       4 debug          Register 1       4 debug
//     Register 2       8 threadId       Register 2       8 threadId
//     Register 3       8 threadId       Register 3       8 threadId
//                                       Register 4       4 controlFlags
//     Stack    0       4 controlFlags   
//
// out abi                               svc
//     Register 0       4 return         Register 0       4 return
//
// conversion
//   Load            controlFlags

    .section .text._ZN2nn3svc7aarch3221GetDebugThreadContextEPNS0_13ThreadContextENS0_6HandleEyj, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch3221GetDebugThreadContextEPNS0_13ThreadContextENS0_6HandleEyj
    .hidden  _ZN2nn3svc7aarch3221GetDebugThreadContextEPNS0_13ThreadContextENS0_6HandleEyj
    .type    _ZN2nn3svc7aarch3221GetDebugThreadContextEPNS0_13ThreadContextENS0_6HandleEyj, %function
_ZN2nn3svc7aarch3221GetDebugThreadContextEPNS0_13ThreadContextENS0_6HandleEyj:

    push     {r4}

    ldr      r4, [sp, #4]              // controlFlags の値 をスタックからレジスタへ

    svc      #NN_SVC_ID_GET_DEBUG_THREAD_CONTEXT

    pop      {r4}
    bx       lr

    .size _ZN2nn3svc7aarch3221GetDebugThreadContextEPNS0_13ThreadContextENS0_6HandleEyj, [.-_ZN2nn3svc7aarch3221GetDebugThreadContextEPNS0_13ThreadContextENS0_6HandleEyj]


//-------------------------------------------------
// Result SetDebugThreadContext(nn::svc::Handle debug, nn::Bit64 threadId, const nn::svc::ThreadContext& context, nn::Bit32 controlFlags)
//
//     AArch32 s=4 r=4 p=4               Invariant s=4 r=8 p=4
// in  abi                               svc
//     Register 0       4 debug          Register 0       4 debug
//                                       Register 1  ref 332 context
//     Register 2       8 threadId       Register 2       8 threadId
//     Register 3       8 threadId       Register 3       8 threadId
//                                       Register 4       4 controlFlags
//     Stack    0  ref 332 context       
//     Stack    1       4 controlFlags   
//
// out abi                               svc
//     Register 0       4 return         Register 0       4 return
//
// conversion
//   Load            context
//   Load            controlFlags

    .section .text._ZN2nn3svc7aarch3221SetDebugThreadContextENS0_6HandleEyRKNS0_13ThreadContextEj, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch3221SetDebugThreadContextENS0_6HandleEyRKNS0_13ThreadContextEj
    .hidden  _ZN2nn3svc7aarch3221SetDebugThreadContextENS0_6HandleEyRKNS0_13ThreadContextEj
    .type    _ZN2nn3svc7aarch3221SetDebugThreadContextENS0_6HandleEyRKNS0_13ThreadContextEj, %function
_ZN2nn3svc7aarch3221SetDebugThreadContextENS0_6HandleEyRKNS0_13ThreadContextEj:

    push     {r4}

    ldr      r1, [sp, #4]              // context の値 をスタックからレジスタへ
    ldr      r4, [sp, #8]              // controlFlags の値 をスタックからレジスタへ

    svc      #NN_SVC_ID_SET_DEBUG_THREAD_CONTEXT

    pop      {r4}
    bx       lr

    .size _ZN2nn3svc7aarch3221SetDebugThreadContextENS0_6HandleEyRKNS0_13ThreadContextEj, [.-_ZN2nn3svc7aarch3221SetDebugThreadContextENS0_6HandleEyRKNS0_13ThreadContextEj]


//-------------------------------------------------
// Result QueryDebugProcessMemory(nn::svc::ilp32::MemoryInfo* pBlockInfo, nn::svc::PageInfo* pPageInfo, nn::svc::Handle process, uintptr_t addr)
//
//     AArch32 s=4 r=4 p=4             Invariant s=4 r=8 p=4
// in  abi                             svc
//     Register 0  ref 40 pBlockInfo   Register 0  ref 40 pBlockInfo
//     Register 1  ref  4 pPageInfo    
//     Register 2       4 process      Register 2       4 process
//     Register 3       4 addr         Register 3       4 addr
//
// out abi                             svc
//     Register 0       4 return       Register 0       4 return
//                                     Register 1       4 pPageInfo
//
// conversion
//   Scatter         pPageInfo

    .section .text._ZN2nn3svc7aarch3223QueryDebugProcessMemoryEPNS0_5ilp3210MemoryInfoEPNS0_8PageInfoENS0_6HandleEj, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch3223QueryDebugProcessMemoryEPNS0_5ilp3210MemoryInfoEPNS0_8PageInfoENS0_6HandleEj
    .hidden  _ZN2nn3svc7aarch3223QueryDebugProcessMemoryEPNS0_5ilp3210MemoryInfoEPNS0_8PageInfoENS0_6HandleEj
    .type    _ZN2nn3svc7aarch3223QueryDebugProcessMemoryEPNS0_5ilp3210MemoryInfoEPNS0_8PageInfoENS0_6HandleEj, %function
_ZN2nn3svc7aarch3223QueryDebugProcessMemoryEPNS0_5ilp3210MemoryInfoEPNS0_8PageInfoENS0_6HandleEj:

    push     {r1}

    svc      #NN_SVC_ID_QUERY_DEBUG_PROCESS_MEMORY

    ldr      r2, [sp, #0]              // pPageInfoのアドレス をスタックからレジスタへ
    str      r1, [r2, #0]              // pPageInfo の第 1 ワードをレジスタからメモリへ

    add      sp, sp, #4
    bx       lr

    .size _ZN2nn3svc7aarch3223QueryDebugProcessMemoryEPNS0_5ilp3210MemoryInfoEPNS0_8PageInfoENS0_6HandleEj, [.-_ZN2nn3svc7aarch3223QueryDebugProcessMemoryEPNS0_5ilp3210MemoryInfoEPNS0_8PageInfoENS0_6HandleEj]


//-------------------------------------------------
// Result ReadDebugProcessMemory(uintptr_t buf, nn::svc::Handle debug, uintptr_t addr, size_t size)
//
//     AArch32 s=4 r=4 p=4         Invariant s=4 r=8 p=4
// in  abi                         svc
//     Register 0       4 buf      Register 0       4 buf
//     Register 1       4 debug    Register 1       4 debug
//     Register 2       4 addr     Register 2       4 addr
//     Register 3       4 size     Register 3       4 size
//
// out abi                         svc
//     Register 0       4 return   Register 0       4 return
//
// conversion

    .section .text._ZN2nn3svc7aarch3222ReadDebugProcessMemoryEjNS0_6HandleEjj, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch3222ReadDebugProcessMemoryEjNS0_6HandleEjj
    .hidden  _ZN2nn3svc7aarch3222ReadDebugProcessMemoryEjNS0_6HandleEjj
    .type    _ZN2nn3svc7aarch3222ReadDebugProcessMemoryEjNS0_6HandleEjj, %function
_ZN2nn3svc7aarch3222ReadDebugProcessMemoryEjNS0_6HandleEjj:

    svc      #NN_SVC_ID_READ_DEBUG_PROCESS_MEMORY
    bx       lr

    .size _ZN2nn3svc7aarch3222ReadDebugProcessMemoryEjNS0_6HandleEjj, [.-_ZN2nn3svc7aarch3222ReadDebugProcessMemoryEjNS0_6HandleEjj]


//-------------------------------------------------
// Result WriteDebugProcessMemory(nn::svc::Handle debug, uintptr_t buf, uintptr_t addr, size_t size)
//
//     AArch32 s=4 r=4 p=4         Invariant s=4 r=8 p=4
// in  abi                         svc
//     Register 0       4 debug    Register 0       4 debug
//     Register 1       4 buf      Register 1       4 buf
//     Register 2       4 addr     Register 2       4 addr
//     Register 3       4 size     Register 3       4 size
//
// out abi                         svc
//     Register 0       4 return   Register 0       4 return
//
// conversion

    .section .text._ZN2nn3svc7aarch3223WriteDebugProcessMemoryENS0_6HandleEjjj, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch3223WriteDebugProcessMemoryENS0_6HandleEjjj
    .hidden  _ZN2nn3svc7aarch3223WriteDebugProcessMemoryENS0_6HandleEjjj
    .type    _ZN2nn3svc7aarch3223WriteDebugProcessMemoryENS0_6HandleEjjj, %function
_ZN2nn3svc7aarch3223WriteDebugProcessMemoryENS0_6HandleEjjj:

    svc      #NN_SVC_ID_WRITE_DEBUG_PROCESS_MEMORY
    bx       lr

    .size _ZN2nn3svc7aarch3223WriteDebugProcessMemoryENS0_6HandleEjjj, [.-_ZN2nn3svc7aarch3223WriteDebugProcessMemoryENS0_6HandleEjjj]


//-------------------------------------------------
// Result SetHardwareBreakPoint(nn::svc::HardwareBreakPointRegisterName regNo, nn::Bit64 control, nn::Bit64 value)
//
//     AArch32 s=4 r=4 p=4          Invariant s=4 r=8 p=4
// in  abi                          svc
//     Register 0       4 regNo     Register 0       4 regNo
//                                  Register 1       8 value
//     Register 2       8 control   Register 2       8 control
//     Register 3       8 control   Register 3       8 control
//                                  Register 4       8 value
//     Stack    0       8 value     
//     Stack    1       8 value     
//
// out abi                          svc
//     Register 0       4 return    Register 0       4 return
//
// conversion
//   Load            value
//   Load            value

    .section .text._ZN2nn3svc7aarch3221SetHardwareBreakPointENS0_30HardwareBreakPointRegisterNameEyy, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch3221SetHardwareBreakPointENS0_30HardwareBreakPointRegisterNameEyy
    .hidden  _ZN2nn3svc7aarch3221SetHardwareBreakPointENS0_30HardwareBreakPointRegisterNameEyy
    .type    _ZN2nn3svc7aarch3221SetHardwareBreakPointENS0_30HardwareBreakPointRegisterNameEyy, %function
_ZN2nn3svc7aarch3221SetHardwareBreakPointENS0_30HardwareBreakPointRegisterNameEyy:

    push     {r4}

    ldr      r1, [sp, #4]              // value の値 をスタックからレジスタへ
    ldr      r4, [sp, #8]              // value の値 をスタックからレジスタへ

    svc      #NN_SVC_ID_SET_HARDWARE_BREAK_POINT

    pop      {r4}
    bx       lr

    .size _ZN2nn3svc7aarch3221SetHardwareBreakPointENS0_30HardwareBreakPointRegisterNameEyy, [.-_ZN2nn3svc7aarch3221SetHardwareBreakPointENS0_30HardwareBreakPointRegisterNameEyy]


//-------------------------------------------------
// Result GetDebugThreadParam(nn::Bit64* pOut1, nn::Bit32* pOut2, nn::svc::Handle debug, nn::Bit64 threadId, nn::svc::DebugThreadParam select)
//
//     AArch32 s=4 r=4 p=4           Invariant s=4 r=8 p=4
// in  abi                           svc
//     Register 0  ref  8 pOut1      Register 0       8 threadId
//     Register 1  ref  4 pOut2      Register 1       8 threadId
//     Register 2       4 debug      Register 2       4 debug
//                                   Register 3       4 select
//     Stack    0       8 threadId   
//     Stack    1       8 threadId   
//     Stack    2       4 select     
//
// out abi                           svc
//     Register 0       4 return     Register 0       4 return
//                                   Register 1       8 pOut1
//                                   Register 2       8 pOut1
//                                   Register 3       4 pOut2
//
// conversion
//   Load            threadId
//   Load            threadId
//   Load            select
//   Scatter         pOut1
//   Scatter         pOut2

    .section .text._ZN2nn3svc7aarch3219GetDebugThreadParamEPyPjNS0_6HandleEyNS0_16DebugThreadParamE, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch3219GetDebugThreadParamEPyPjNS0_6HandleEyNS0_16DebugThreadParamE
    .hidden  _ZN2nn3svc7aarch3219GetDebugThreadParamEPyPjNS0_6HandleEyNS0_16DebugThreadParamE
    .type    _ZN2nn3svc7aarch3219GetDebugThreadParamEPyPjNS0_6HandleEyNS0_16DebugThreadParamE, %function
_ZN2nn3svc7aarch3219GetDebugThreadParamEPyPjNS0_6HandleEyNS0_16DebugThreadParamE:

    push     {r0,r1,r4}

    ldr      r0, [sp, #12]             // threadId の値 をスタックからレジスタへ
    ldr      r1, [sp, #16]             // threadId の値 をスタックからレジスタへ
    ldr      r3, [sp, #20]             // select の値 をスタックからレジスタへ

    svc      #NN_SVC_ID_GET_DEBUG_THREAD_PARAM

    ldr      r4, [sp, #0]              // pOut1のアドレス をスタックからレジスタへ
    str      r1, [r4, #0]              // pOut1 の第 1 ワードをレジスタからメモリへ
    str      r2, [r4, #4]              // pOut1 の第 2 ワードをレジスタからメモリへ
    ldr      r4, [sp, #4]              // pOut2のアドレス をスタックからレジスタへ
    str      r3, [r4, #0]              // pOut2 の第 1 ワードをレジスタからメモリへ

    add      sp, sp, #8
    pop      {r4}
    bx       lr

    .size _ZN2nn3svc7aarch3219GetDebugThreadParamEPyPjNS0_6HandleEyNS0_16DebugThreadParamE, [.-_ZN2nn3svc7aarch3219GetDebugThreadParamEPyPjNS0_6HandleEyNS0_16DebugThreadParamE]


    .end

