﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Nintendo;
using Nintendo.ServiceFramework;
using Nintendo.ServiceFramework.CppCode;
using Nintendo.ServiceFramework.Hipc;
using nn;
using nn.sf;
using std;

namespace nn.socket.sf
{
    [CppRefPath(@"<nn/socket/sfdl/socket.bsd.sfdl.h>")]
    public struct LibraryConfigData
    {
        public uint32_t  version;
        public uint32_t  tcpInitialSendBufferSize;
        public uint32_t  tcpInitialReceiveBufferSize;
        public uint32_t  tcpAutoSendBufferSizeMax;
        public uint32_t  tcpAutoReceiveBufferSizeMax;
        public uint32_t  udpSendBufferSize;
        public uint32_t  udpReceiveBufferSize;
        public int32_t   socketBufferEfficiency;
    }

    [CppRefPath(@"<nn/socket/sfdl/socket.bsd.sfdl.h>")]
    public struct SelectTimeval
    {
        public int64_t  sec;
        public int64_t  usec;
        public bool wasNull;
    }

    [CppRefPath(@"<nn/socket/sfdl/socket.bsd.sfdl.h>")]
    public struct Timespec
    {
        public int64_t  sec;
        public int64_t  nsec;
    }

    [CppRefPath(@"<nn/socket/sfdl/socket.bsd.sfdl.h>")]
    public struct Iovec
    {
        public int64_t iov_base;
        public int64_t iov_len;
    }

    [CppRefPath(@"<nn/socket/sfdl/socket.bsd.sfdl.h>")]
    public struct MsgHdr
    {
        public uint64_t msg_name;
        public uint64_t msg_namelen;
        [FixedArray(2)]
        public Iovec[]  msg_iov;
        public uint64_t msg_iovlen;
        public uint64_t msg_control;
        public uint64_t msg_controllen;
        public int64_t  msg_flags;
    }

    [CppRefPath(@"<nn/socket/sfdl/socket.bsd.sfdl.h>")]
    public interface IClient : IServiceObject
    {
        [MethodId(0)]
        Result RegisterClient(
            Out<int_t> pOutRet,
            [ProcessId] nn.Bit64 pid,
            NativeHandle memoryHandle,
            uint64_t memorySize,
            LibraryConfigData configData);

        [MethodId(1)]
        Result StartMonitoring(
            [ProcessId] nn.Bit64 pid);

        [MethodId(2)]
        // int Socket(int domain, int type, int protocol)
        Result Socket(
            Out<int_t> pOutRet,
            Out<int_t> pOutError,
            int_t domain,
            int_t type,
            int_t protocol);

        [MethodId(3)]
        // int SocketShutdownExempt(int domain, int type, int protocol)
        Result SocketExempt(
            Out<int_t> pOutRet,
            Out<int_t> pOutError,
            int_t domain,
            int_t type,
            int_t protocol);

        [MethodId(4)]
        // int Open(const char* path, int flags)
        Result Open(
            Out<int_t> pOutRet,
            Out<int_t> pOutError,
            [AutoSelectBuffer] nn.sf.InBuffer path,
            int_t flags);

        [MethodId(5)]
        // int Select(int numberOfDescriptors, fd_set *pReadDescriptors, fd_set *pWriteDescriptors, fd_set *pExceptDescriptors, timeval *pTimeout)
        Result Select(
            Out<int_t> pOutRet,
            Out<int_t> pOutError,
            int_t numberOfDescriptors,
            [AutoSelectBuffer] nn.sf.InBuffer inReadDescriptors,
            [AutoSelectBuffer] nn.sf.InBuffer inWriteDescriptors,
            [AutoSelectBuffer] nn.sf.InBuffer inExceptDescriptors,
            [AutoSelectBuffer] nn.sf.OutBuffer outReadDescriptors,
            [AutoSelectBuffer] nn.sf.OutBuffer outWriteDescriptors,
            [AutoSelectBuffer] nn.sf.OutBuffer outExceptDescriptors,
            SelectTimeval timeout);

        [MethodId(6)]
        // int Poll(pollfd *pSocketDescriptors, nfds_t numberOfDescriptors, int timeoutMilliseconds)
        Result Poll(
            Out<int_t> pOutRet,
            Out<int_t> pOutError,
            [AutoSelectBuffer] nn.sf.InBuffer inDescriptors,
            [AutoSelectBuffer] nn.sf.OutBuffer outDescriptors,
            int_t numberOfDescriptors,
            int_t timeoutMilliseconds);

        [MethodId(7)]
        // int Sysctl(int* mibEntries, size_t mibEntryCount, void* pOldValue, size_t* pOldValueLength, void* pNewValue, size_t newValueLength)
        Result Sysctl(
            Out<int_t> pOutRet,
            Out<int_t> pOutError,
            [AutoSelectBuffer] nn.sf.InBuffer mib,
            [AutoSelectBuffer] nn.sf.OutBuffer outValue,
            Out<uint_t> pOutValueLength,
            [AutoSelectBuffer] nn.sf.InBuffer inValue);

        [MethodId(8)]
        // ssize_t Recv(int socket, void* outBuffer, size_t outBufferLength, int flags)
        Result Recv(
            Out<int_t> pOutRet,
            Out<int_t> pOutError,
            int_t sock,
            [AutoSelectBuffer] nn.sf.OutBuffer outBuffer,
            int_t flags);

        [MethodId(9)]
        // ssize_t RecvFrom(int socket, void* outBuffer, size_t outBufferLength, int flags, sockaddr* outAddress, socklen_t* outAddressLength)
        Result RecvFrom(
            Out<int_t> pOutRet,
            Out<int_t> pOutError,
            int_t sock,
            [AutoSelectBuffer] nn.sf.OutBuffer outBuffer,
            int_t flags,
            [AutoSelectBuffer] nn.sf.OutBuffer pOutAddress,
            Out<uint_t> pOutAddressLength);

        [MethodId(10)]
        // ssize_t Send(int socket, const void* inBuffer, size_t inBufferLength, int flags)
        Result Send(
            Out<int_t> pOutRet,
            Out<int_t> pOutError,
            int_t sock,
            [AutoSelectBuffer] nn.sf.InBuffer inBuffer,
            int_t flags);

        [MethodId(11)]
        // ssize_t SendTo(int socket, const void* inBuffer, size_t inBufferLength, int flags, const sockaddr* inAddress, socklen_t inAddressLength)
        Result SendTo(
            Out<int_t> pOutRet,
            Out<int_t> pOutError,
            int_t sock,
            [AutoSelectBuffer] nn.sf.InBuffer inBuffer,
            int_t flags,
            [AutoSelectBuffer] nn.sf.InBuffer inAddress);

        [MethodId(12)]
        // int Accept(int socket, sockaddr* outAddress, socklen_t* outAddressLength)
        Result Accept(
            Out<int_t> pOutRet,
            Out<int_t> pOutError,
            int_t sock,
            [AutoSelectBuffer] nn.sf.OutBuffer pOutAddress,
            Out<uint_t> pOutAddressLength);

        [MethodId(13)]
        // int Bind(int socket, const sockaddr* inAddress, socklen_t inAddressLength)
        Result Bind(
            Out<int_t> pOutRet,
            Out<int_t> pOutError,
            int_t sock,
            [AutoSelectBuffer] nn.sf.InBuffer inAddress);

        [MethodId(14)]
        // int Connect(int socket, const sockaddr* inAddress, socklen_t inAddressLength)
        Result Connect(
            Out<int_t> pOutRet,
            Out<int_t> pOutError,
            int_t sock,
            [AutoSelectBuffer] nn.sf.InBuffer inAddress);

        [MethodId(15)]
        // int GetPeerName(int socket, sockaddr* outAddress, socklen_t* outAddressLength)
        Result GetPeerName(
            Out<int_t> pOutRet,
            Out<int_t> pOutError,
            int_t sock,
            [AutoSelectBuffer] nn.sf.OutBuffer pOutAddress,
            Out<uint_t> pOutAddressLength);

        [MethodId(16)]
        // int GetSockName(int socket, sockaddr* outAddress, socklen_t* outAddressLength)
        Result GetSockName(
            Out<int_t> pOutRet,
            Out<int_t> pOutError,
            int_t sock,
            [AutoSelectBuffer] nn.sf.OutBuffer pOutAddress,
            Out<uint_t> pOutAddressLength);

        [MethodId(17)]
        // int GetSockOpt(int socket, int level, int optionName, void* outOptionValue, socklen_t* outOptionLength)
        Result GetSockOpt(
            Out<int_t> pOutRet,
            Out<int_t> pOutError,
            int_t sock,
            int_t level,
            int_t optionName,
            [AutoSelectBuffer] nn.sf.OutBuffer pOutOptionValue,
            Out<uint_t> pOutOptionLength);

        [MethodId(18)]
        // int Listen(int socket, int backlog)
        Result Listen(
            Out<int_t> pOutRet,
            Out<int_t> pOutError,
            int_t sock,
            int_t backlog);

        [MethodId(19)]
        // int Ioctl(int socket, uint32_t command, void* data, size_t dataLength)
        Result Ioctl(
            Out<int_t> pOutRet,
            Out<int_t> pOutError,
            int_t sock,
            uint32_t command,
            [AutoSelectBuffer] nn.sf.InBuffer dataInSlot0,
            [AutoSelectBuffer] nn.sf.InBuffer dataInSlot1,
            [AutoSelectBuffer] nn.sf.InBuffer dataInSlot2,
            [AutoSelectBuffer] nn.sf.InBuffer dataInSlot3,
            [AutoSelectBuffer] nn.sf.OutBuffer dataOutSlot0,
            [AutoSelectBuffer] nn.sf.OutBuffer dataOutSlot1,
            [AutoSelectBuffer] nn.sf.OutBuffer dataOutSlot2,
            [AutoSelectBuffer] nn.sf.OutBuffer dataOutSlot3,
            int_t embeddedSegmentCount);

        [MethodId(20)]
        // int Fcntl(int socket, int command, ...)
        Result Fcntl(
            Out<int_t> pOutRet,
            Out<int_t> pOutError,
            int_t sock,
            int_t command,
            int_t iocmd);

        [MethodId(21)]
        // int SetSockOpt(int socket, int level, int optionName, const void* inOptionValue, socklen_t inOptionLength)
        Result SetSockOpt(
            Out<int_t> pOutRet,
            Out<int_t> pOutError,
            int_t sock,
            int_t level,
            int_t optionName,
            [AutoSelectBuffer] nn.sf.InBuffer inOptionValue);

        [MethodId(22)]
        // int Shutdown(int socket, int how)
        Result Shutdown(
            Out<int_t> pOutRet,
            Out<int_t> pOutError,
            int_t sock,
            int_t how);

        [MethodId(23)]
        // int ShutdownAllSockets(int forced)
        Result ShutdownAllSockets(
            Out<int_t> pOutRet,
            Out<int_t> pOutError,
            int_t forced);

        [MethodId(24)]
        // int Write(int socket, const void *inBuffer, size_t inBufferLength)
        Result Write(
            Out<int_t> pOutRet,
            Out<int_t> pOutError,
            int_t sock,
            [AutoSelectBuffer] nn.sf.InBuffer inBuffer);

        [MethodId(25)]
        // int Read(int socket, void *outBuffer, size_t outBufferLength)
        Result Read(
            Out<int_t> pOutRet,
            Out<int_t> pOutError,
            int_t sock,
            [AutoSelectBuffer] nn.sf.OutBuffer outBuffer);

        [MethodId(26)]
        // int Close(int socket)
        Result Close(
            Out<int_t> pOutRet,
            Out<int_t> pOutError,
            int_t sock);

        [MethodId(27)]
        // int DuplicateSocket(int socket, uint64_t ownerProcessId);
        Result DuplicateSocket(
            Out<int_t> pOutRet,
            Out<int_t> pOutError,
            int_t sock,
            nn.Bit64 ownerProcessId);

        [MethodId(28)]
        // int GetResourceStatistics(StatisticsType type, void* outBuffer, size_t outBufferLength, uint32_t options)
        Result GetResourceStatistics(
            Out<int_t>  pOutRet,
            Out<int_t>  pOutError,
            [ProcessId] nn.Bit64 pid,
            int_t       type,
            [AutoSelectBuffer] nn.sf.OutBuffer outBuffer,
            uint_t      options);

        [MethodId(29)]
        // ssize_t RecvMMsg(int socket, struct mmsghdr* msgvec, size_t numMessages, int flags, struct timespec *timeout)
        Result RecvMMsg(
            Out<int_t> pOutRet,
            Out<int_t> pOutError,
            int_t sock,
            [AutoSelectBuffer] nn.sf.OutBuffer outBuffer,
            uint_t numMessages,
            int_t flags,
            Timespec timeout);

        [MethodId(30)]
        // ssize_t SendMMsg(int socket, const struct mmsghdr* msgvec, size_t numMessages, int flags)
        Result SendMMsg(
            Out<int_t> pOutRet,
            Out<int_t> pOutError,
            int_t sock,
            [AutoSelectBuffer] nn.sf.InArray<nn.socket.sf.MsgHdr> inArrayMsgHdr,
            uint_t numMessages,
            [AutoSelectBuffer] nn.sf.InBuffer inBufferPackedMsgHdrData,
            int_t flags);
    }
}
