﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
/*
  Based on:
  -
   Copyright 1994, 1995 Massachusetts Institute of Technology

   Permission to use, copy, modify, and distribute this software and
   its documentation for any purpose and without fee is hereby
   granted, provided that both the above copyright notice and this
   permission notice appear in all copies, that both the above
   copyright notice and this permission notice appear in all
   supporting documentation, and that the name of M.I.T. not be used
   in advertising or publicity pertaining to distribution of the
   software without specific, written prior permission.  M.I.T. makes
   no representations about the suitability of this software for any
   purpose.  It is provided "as is" without express or implied
   warranty.

   THIS SOFTWARE IS PROVIDED BY M.I.T. ``AS IS''.  M.I.T. DISCLAIMS
   ALL EXPRESS OR IMPLIED WARRANTIES WITH REGARD TO THIS SOFTWARE,
   INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
   MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. IN NO EVENT
   SHALL M.I.T. BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
   SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
   LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
   USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
   ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
   OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
   OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
   SUCH DAMAGE.
 */

#include <cstdio>
#include <nn/os.h>
#include <nn/socket/socket_Types.h>
#include <nn/util/util_FormatString.h>

namespace nn     {
namespace socket {
namespace detail {

char* socketNtoa(InAddr networkAddress)
NN_NOEXCEPT
{
    static char buffer[4 * sizeof("123")];
    unsigned char *pAddressParts = (uint8_t *)&networkAddress;

    nn::util::SNPrintf(buffer, sizeof(buffer), "%d.%d.%d.%d",
        pAddressParts[0] & 0xff,
        pAddressParts[1] & 0xff,
        pAddressParts[2] & 0xff,
        pAddressParts[3] & 0xff);

    return buffer;
}

char* socketNtoa(in_addr networkAddress)
NN_NOEXCEPT
{
    static char buffer[4 * sizeof("123")];
    unsigned char *pAddressParts = (uint8_t *)&networkAddress;

    nn::util::SNPrintf(buffer, sizeof(buffer), "%d.%d.%d.%d",
        pAddressParts[0] & 0xff,
        pAddressParts[1] & 0xff,
        pAddressParts[2] & 0xff,
        pAddressParts[3] & 0xff);

    return buffer;
}

char* socketNtoaR(InAddr networkAddress, char *buffer, size_t length)
NN_NOEXCEPT
{
    unsigned char *pAddressParts = (uint8_t *)&networkAddress;

    nn::util::SNPrintf(buffer, length, "%d.%d.%d.%d",
        pAddressParts[0] & 0xff,
        pAddressParts[1] & 0xff,
        pAddressParts[2] & 0xff,
        pAddressParts[3] & 0xff);

    return buffer;
}

char* socketNtoaR(struct in_addr networkAddress, char *buffer, size_t length)
NN_NOEXCEPT
{
    unsigned char *pAddressParts = (uint8_t *)&networkAddress;

    nn::util::SNPrintf(buffer, length, "%d.%d.%d.%d",
        pAddressParts[0] & 0xff,
        pAddressParts[1] & 0xff,
        pAddressParts[2] & 0xff,
        pAddressParts[3] & 0xff);

    return buffer;
}

}}}
