﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/sf/sf_Types.h>
#include <nn/socket/sfdl/socket.bsd.sfdl.h>

namespace nn { namespace socket { namespace detail
{
    nn::sf::SharedPointer<nn::socket::sf::IClient>
        CreateClientMonitorByHipc(const char* pServicePortName) NN_NOEXCEPT;

    nn::sf::SharedPointer<nn::socket::sf::IClient>
        CreateClientServiceByHipc(int sessionCount, const char* pServicePortName) NN_NOEXCEPT;

    void DestroyClientMonitorByHipc(
        nn::sf::SharedPointer<nn::socket::sf::IClient>* pClient) NN_NOEXCEPT;

    void DestroyClientServiceByHipc(
        nn::sf::SharedPointer<nn::socket::sf::IClient>* pClient) NN_NOEXCEPT;

}}} // namespace nn::socket::detail
