﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Abort.h>
#include <nn/nn_Common.h>
#include <nn/sf/sf_ExpHeapAllocator.h>
#include <nn/sf/sf_HipcClient.h>
#include <nn/sf/sf_HipcClientProxyByName.h>
#include <nn/socket/private/session.h>
#include <nn/socket/sfdl/socket.bsd.sfdl.h>

namespace nn { namespace socket { namespace detail { namespace
{
    nn::sf::HipcSimpleClientSessionManager g_Domain;

    // Allocator for service objects
    struct CreateServiceTag;
    typedef nn::sf::ExpHeapStaticAllocator<4 * 1024, CreateServiceTag> MyAllocator;

    // static Initializer for MyAllocator
    class MyAllocatorInitializer
    {
    public:
        MyAllocatorInitializer() NN_NOEXCEPT
        {
            MyAllocator::Initialize(nn::lmem::CreationOption_NoOption);
        }
    } g_SocketAllocatorInitializer;

}}}} // namespace nn::socket::detail::<unnamed>

namespace nn { namespace socket { namespace detail
{
    nn::sf::SharedPointer<nn::socket::sf::IClient>
    CreateClientMonitorByHipc(const char* pServicePortName) NN_NOEXCEPT
    {
        nn::sf::SharedPointer<nn::socket::sf::IClient> pService;

        Result result = nn::sf::CreateHipcProxyByName<
            nn::socket::sf::IClient, MyAllocator::Policy>(&pService, pServicePortName);
        NN_ABORT_UNLESS_RESULT_SUCCESS(result);

        return pService;
    }

    nn::sf::SharedPointer<nn::socket::sf::IClient>
    CreateClientServiceByHipc(int sessionCount, const char* pServicePortName) NN_NOEXCEPT
    {
        nn::sf::SharedPointer<nn::socket::sf::IClient> pService;

        // Create a new sub domain and get a service object in the sub domain.
        NN_ABORT_UNLESS_RESULT_SUCCESS((g_Domain.InitializeByName<
            nn::socket::sf::IClient, MyAllocator::Policy>(&pService, pServicePortName)));

        // Set the number of sessions for the sub domain.
        // Service objects in the same sub domain share these sessions.
        NN_ABORT_UNLESS_RESULT_SUCCESS(g_Domain.SetSessionCount(sessionCount));

        return pService;
    }

    void DestroyClientMonitorByHipc(
        nn::sf::SharedPointer<nn::socket::sf::IClient>* pClient) NN_NOEXCEPT
    {
        NN_SDK_ASSERT_NOT_NULL(pClient);
        pClient->Reset();
        g_Domain.Finalize();
    }

    void DestroyClientServiceByHipc(
        nn::sf::SharedPointer<nn::socket::sf::IClient>* pClient) NN_NOEXCEPT
    {
        NN_SDK_ASSERT_NOT_NULL(pClient);
        pClient->Reset();
    }

}}} // namespace nn::socket::detail
