﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/os/os_Mutex.h>
#include <nn/os/os_ConditionVariable.h>
#include <nn/sf/hipc/sf_HipcHandleTypes.h>

#include "sf_HipcEmulatedServiceResolver.h"


namespace nn { namespace sf { namespace hipc {

class HipcEmulatedInProcessServiceResolver
    : public HipcEmulatedServiceResolver<HipcClientPortHandle>
{
private:
    mutable os::Mutex m_Mutex;
    mutable os::ConditionVariable m_Condition;

protected:
    virtual HipcClientPortHandle GetServicePortImpl(const char* name) NN_NOEXCEPT NN_OVERRIDE;

public:
    HipcEmulatedInProcessServiceResolver() NN_NOEXCEPT
        : m_Mutex(false)
    {
    }

    virtual Result RegisterService(HipcServerPortHandle* pOut, const char* name, int32_t maxSessions) NN_NOEXCEPT NN_OVERRIDE;
    virtual void UnregisterService(const char* name) NN_NOEXCEPT NN_OVERRIDE;

    virtual bool IsServiceRegistered(const char* name) NN_NOEXCEPT NN_OVERRIDE;
};

}}}
