﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "sdmmc_PortGcAsic0.h"
#if (defined(NN_BUILD_CONFIG_HARDWARE_JETSONTK1))
    #include "sdmmc_SdmmcController.tegra-k1.h"
#endif
#if (defined(NN_BUILD_CONFIG_HARDWARE_JETSONTK2) || defined(NN_BUILD_CONFIG_HARDWARE_NX))
    #include "sdmmc_SdmmcController.tegra-x1.h"
#endif

namespace nn { namespace sdmmc {
namespace detail {

namespace
{
    Sdmmc2Controller g_GcAsic0HostController;
    #if (defined(NN_DETAIL_SDMMC_ATTACH_MMC_TO_PORT_GC_ASIC_0_FOR_DEBUG))  // デバッグ用に GC ASIC ポート 0 番に MMC を接続する場合
        MmcDeviceAccessor g_GcAsic0DeviceAccessor(&g_GcAsic0HostController);
    #else   // 通常
        GcAsicDeviceAccessor g_GcAsic0DeviceAccessor(&g_GcAsic0HostController);
    #endif
}

IHostController* GetHostControllerOfPortGcAsic0() NN_NOEXCEPT
{
    return &g_GcAsic0HostController;
}

IDeviceAccessor* GetDeviceAccessorOfPortGcAsic0() NN_NOEXCEPT
{
    return &g_GcAsic0DeviceAccessor;
}

#if (defined(NN_DETAIL_SDMMC_ATTACH_MMC_TO_PORT_GC_ASIC_0_FOR_DEBUG))  // デバッグ用に GC ASIC ポート 0 番に MMC を接続する場合
    MmcDeviceAccessor* GetMmcDeviceAccessorOfPortGcAsic0() NN_NOEXCEPT
    {
        return &g_GcAsic0DeviceAccessor;
    }
#else
    GcAsicDeviceAccessor* GetGcAsicDeviceAccessorOfPortGcAsic0() NN_NOEXCEPT
    {
        return &g_GcAsic0DeviceAccessor;
    }
#endif

} // namespace detail {
}} // namespace nn { namespace sdmmc {
