﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "sdmmc_Log.h"
#include <nn/nn_Abort.h>

namespace nn { namespace sdmmc {
namespace detail {

void LogData(void* pData, size_t dataSize) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_NOT_NULL(pData);
    if (dataSize == 0)
    {
        return;
    }
    uint8_t* pCurrentData = reinterpret_cast<uint8_t*>(pData);
    uint8_t* pDataEnd = pCurrentData + dataSize;
    while (true)
    {
        for (uint8_t i = 0; i < 0x10; i++)
        {
            NN_DETAIL_SDMMC_LOG("%02X ", *pCurrentData);
            pCurrentData++;
            if (pCurrentData >= pDataEnd)
            {
                NN_DETAIL_SDMMC_LOG("\n");
                return;
            }
        }
        NN_DETAIL_SDMMC_LOG("\n");
    }
}

} // namespace detail {
}} // namespace nn { namespace sdmmc {
