﻿/*---------------------------------------------------------------------------*
  Copyright (C)2014 Nintendo Co., Ltd.  All rights reserved.

  These coded instructions, statements, and computer programs contain
  proprietary information of Nintendo of America Inc. and/or Nintendo
  Company Ltd., and are protected by Federal copyright law.  They may
  not be disclosed to third parties or copied or duplicated in any form,
  in whole or in part, without the prior written consent of Nintendo.
 *---------------------------------------------------------------------------*/

#include <nn/TargetConfigs/build_Base.h>
#include <nn/TargetConfigs/build_Fpu.h>
#include <nn/svc/svc_BaseId.autogen.h>
#include "rtld.AssemblyOffset.h"

#ifndef NN_BUILD_CONFIG_FPU_NUM_DOUBLE_REGISTERS
#error not define NN_BUILD_CONFIG_FPU_NUM_DOUBLE_REGISTERS
#endif

    .section ".rtld.init", "ax"
    .align   2
    .global  _start
    .type    _start, %function
_start:
    b       .Lrtld_start
    .word   __rocrt - _start

.Lrtld_start:
    cmp     r0, #0
    bne     .Lhandle_exception
    mov     r4, r1

    // bss クリア
    bl      2f
1:  .word   __bss_start - 1b
2:  ldr     r0, [lr]
    add     r0, r0, lr

    bl      2f
1:  .word   __bss_end - 1b
2:  ldr     r2, [lr]
    add     r2, r2, lr
    sub     r2, r2, r0

    mov     r1, #0
    bl      memset

    // get load base address
    //  r4 <- thread handle
    bl      2f
1:  .word   _start - 1b
2:  ldr     r0, [lr]
    add     r0, r0, lr  // r0 <- load base address


    // get .dynamic address
    //  r0 <- load base address
    //  r4 <- thread handle
    bl      2f
1:  .word   _DYNAMIC - 1b
2:  ldr     r1, [lr]
    add     r1, r1, lr  //  r1 <- .dynamic address

    // r0 <- load base address
    // r1 <- .dynamic address
    // r4 <- thread handle
    mov     r5, r0
    mov     r6, r1
    bl      _ZN2nn4rtld11Initialize0EjPKNS_2ro6detail3Elf5Elf323DynE
    mov     r0, r5
    mov     r1, r6
    bl      _ZN2nn4rtld11Initialize1EjPKNS_2ro6detail3Elf5Elf323DynE

    // os ライブラリ初期化
    mov     r0, r4

    ldr     ip, .LGOT
    adr     r1, .LGOT
    add     ip, ip, r1      // ip <- GOT
    ldr     r1, .L__arg_start
    ldr     r1, [ip, r1]    // r1 <- __arg_start

    bl      2f
1:  .word   _ZN2nn4rtld22EnableExceptionHandlerEv - 1b
2:  ldr     r2, [lr]
    add     r2, r2, lr

    bl      2f
1:  .word   _ZN2nn4rtld8CallInitEv - 1b
2:  ldr     r3, [lr]
    add     r3, r3, lr

    bl      _ZN2nn4init5StartEjjPFvvES2_(PLT)
1:  b       1b
    .ltorg





.Lhandle_exception:
    // 未初期化の場合は多重例外を防ぐ
    bl      2f
1:  .word   __rt_initialized - 1b
2:  ldr     r2, [lr]
    add     r2, r2, lr
    ldr     r2, [r2]
    cmp     r2, #0
    beq     .Lnot_handled

    ldr     r3, .LGOT
    adr     r2, .LGOT
    add     r3, r3, r2      // r3 <- GOT
    ldr     r2, .L_ZN2nn2os6detail20UserExceptionHandlerEv
    ldr     r2, [r3, r2]    // r2 <- _ZN2nn2os6detail20UserExceptionHandlerEv
    blx     r2

.Lnot_handled:
    ldr     r0, =RESULT_NOT_HANDLED
    bl      _ZN2nn3svc7aarch3219ReturnFromExceptionENS_6ResultE
6:  b       6b
    .size   _start, [. - _start]

.LGOT:
    .word _GLOBAL_OFFSET_TABLE_ - .LGOT
.L__arg_start:
    .word __arg_start(GOT)
.L_ZN2nn2os6detail20UserExceptionHandlerEv:
    .word _ZN2nn2os6detail20UserExceptionHandlerEv(GOT)

    .section .text, "ax"
    .align   2
    .global  _ZN2nn4rtld9BindEntryEv
    .type    _ZN2nn4rtld9BindEntryEv, %function
_ZN2nn4rtld9BindEntryEv:
    // 既に lr は save済み
    // ip = &got[n + 3]
    // lr = &got[2]

    push    {r0 - r4}
    vpush   {d0 - d7}

    sub     r1, ip, lr
    sub     r1, r1, #4
    lsr     r1, r1, #2
    ldr     r0, [lr, #-4]
    mov     r4, ip

    bl      _ZN2nn4rtld4BindEPNS_2ro6detail8RoModuleEj

    str     r0, [r4]
    mov     ip, r0
    vpop    {d0 - d7}
    pop     {r0 - r4, lr}
    bx      ip

    .size   _ZN2nn4rtld9BindEntryEv, [. - _ZN2nn4rtld9BindEntryEv]

    .section .text, "ax"
    .align   2
    .global  _ZN2nn4rtld22EnableExceptionHandlerEv
    .type    _ZN2nn4rtld22EnableExceptionHandlerEv, %function
_ZN2nn4rtld22EnableExceptionHandlerEv:
    mov     r0, lr

    bl      2f
1:  .word   __rt_initialized - 1b
2:  ldr     r2, [lr]
    add     r2, r2, lr
    mov     r1, #1
    str     r1, [r2]

    bx      r0
    .size   _ZN2nn4rtld22EnableExceptionHandlerEv, [. - _ZN2nn4rtld22EnableExceptionHandlerEv]

    .data
    .balign 8
__rt_initialized:
    .word   0
    .size   __rt_initialized, [. - __rt_initialized]
