﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

extern "C"
{
    extern void (*__init_array_start []) ();
    extern void (*__init_array_end []) ();

    // for TLS
    extern unsigned char            __EX_start[] __attribute__((weak));
    extern unsigned char            __EX_end[] __attribute__((weak));
    extern unsigned char            __tdata_start[] __attribute__((weak));
    extern unsigned char            __tdata_end[] __attribute__((weak));
    extern unsigned char            __tdata_align_abs[] __attribute__((weak));
    extern unsigned char            __tdata_align_rel[] __attribute__((weak));
    extern unsigned char            __tbss_start[] __attribute__((weak));
    extern unsigned char            __tbss_end[] __attribute__((weak));
    extern unsigned char            __tbss_align_abs[] __attribute__((weak));
    extern unsigned char            __tbss_align_rel[] __attribute__((weak));
    extern unsigned char            __rela_dyn_start[] __attribute__((weak));
    extern unsigned char            __rela_dyn_end[] __attribute__((weak));
    extern unsigned char            __rel_dyn_start[] __attribute__((weak));
    extern unsigned char            __rel_dyn_end[] __attribute__((weak));
    extern unsigned char            __rela_plt_start[] __attribute__((weak));
    extern unsigned char            __rela_plt_end[] __attribute__((weak));
    extern unsigned char            __rel_plt_start[] __attribute__((weak));
    extern unsigned char            __rel_plt_end[] __attribute__((weak));
    extern unsigned char            __got_start[] __attribute__((weak));
    extern unsigned char            __got_end[] __attribute__((weak));
    extern unsigned char            _DYNAMIC[] __attribute__((weak));
    int __nnmusl_init_dso(unsigned char *EX_start, unsigned char *EX_end,
                            unsigned char *tdata_start, unsigned char *tdata_end,
                            unsigned char *tdata_align_abs, unsigned char *tdata_align_rel,
                            unsigned char *tbss_start, unsigned char *tbss_end,
                            unsigned char *tbss_align_abs, unsigned char *tbss_align_rel,
                            unsigned char *got_start, unsigned char *got_end,
                            unsigned char *rela_dyn_start, unsigned char *rela_dyn_end,
                            unsigned char *rel_dyn_start, unsigned char *rel_dyn_end,
                            unsigned char *rela_plt_start, unsigned char *rela_plt_end,
                            unsigned char *rel_plt_start, unsigned char *rel_plt_end,
                            unsigned char *DYNAMIC);
    void __nnmusl_fini_dso(unsigned char *EX_start, unsigned char *EX_end,
                            unsigned char *tdata_start, unsigned char *tdata_end,
                            unsigned char *tbss_start, unsigned char *tbss_end);

    void* __dso_handle __attribute__ ((visibility ("hidden"))) = &__dso_handle;
    int __aeabi_atexit(void* object, void (*destroyer)(void*), void* dso_handle) __attribute__ ((visibility ("hidden")));
    int __cxa_atexit(void (*destroyer)(void*), void* pObject, void* dso_handle) __attribute__ ((visibility ("hidden")));
    int __cxa_finalize(void* pDsoHandle) __attribute__ ((visibility ("hidden")));
    void _init() __attribute__ ((visibility ("protected")));
    void _fini() __attribute__ ((visibility ("protected")));
    void __nninitStartupRefer() __attribute__ ((visibility ("hidden")));
#if defined(__NX_TOOLCHAIN_VERSION__)
    static volatile int nnmuslTlsInitializationPhase = 0;
#endif

    void _init()
    {
#if defined(__NX_TOOLCHAIN_VERSION__)
        if (nnmuslTlsInitializationPhase == 0)
        {
            nnmuslTlsInitializationPhase = __nnmusl_init_dso( __EX_start, __EX_end,
                                            __tdata_start, __tdata_end,
                                            __tdata_align_abs, __tdata_align_rel,
                                            __tbss_start, __tbss_end,
                                            __tbss_align_abs, __tbss_align_rel,
                                            __got_start, __got_end,
                                            __rela_dyn_start, __rela_dyn_end,
                                            __rel_dyn_start, __rel_dyn_end,
                                            __rela_plt_start, __rela_plt_end,
                                            __rel_plt_start, __rel_plt_end,
                                            (unsigned char *)_DYNAMIC );
            if (nnmuslTlsInitializationPhase == 1)
            {
                return;
            }
        }
#endif

        for (void (**f)() = __init_array_start; f < __init_array_end; ++f)
        {
            (*f)();
        }
    }

    void _fini()
    {
#if defined(__NX_TOOLCHAIN_VERSION__)
        __nnmusl_fini_dso( __EX_start, __EX_end,
                            __tdata_start, __tdata_end,
                            __tbss_start, __tbss_end );
#endif
    }

    int __aeabi_atexit(void* object, void (*destroyer)(void*), void* dso_handle)
    {
        return __cxa_atexit(destroyer, object, dso_handle);
    }

    int __cxa_atexit(void (*pDestroyer)(void*), void* pObject, void* pDsoHandle)
    {
        return 0;
    }

    int __cxa_finalize(void* pDsoHandle)
    {
        return 0;
    }

    // nnApplication.o 等がリンクされていない場合、未解決シンボルエラーにする。
    // __nnDetailNintendoSdkRuntimeObjectFile は nnApplication.o 等がエクスポートする。
    extern void __nnDetailNintendoSdkRuntimeObjectFile();
    void __nnDetailNintendoSdkRuntimeObjectFileRefer()
    {
        __nnDetailNintendoSdkRuntimeObjectFile();
    }
}

