﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/pm/pm_InformationApi.h>
#include <nn/pm/detail/pm_InformationInterface.h>

#include <nn/svc/svc_Handle.h>

#include <nn/sf/sf_HipcClient.h>
#include <nn/sf/sf_ExpHeapAllocator.h>


namespace nn { namespace pm {

    namespace
    {
        struct AllocatorTag
        {
        };

        typedef nn::sf::ExpHeapStaticAllocator<1024, AllocatorTag> MyAllocator;

        nn::sf::SharedPointer<nn::pm::detail::IInformationInterface> g_RefInformationInterface;
        bool g_IsInitialized = false;
    }

    Result InitializeForInformation() NN_NOEXCEPT
    {
        NN_SDK_ASSERT( ! g_IsInitialized );

        MyAllocator::Initialize(nn::lmem::CreationOption_NoOption);

        Result result = nn::sf::CreateHipcProxyByName<
            nn::pm::detail::IInformationInterface, MyAllocator::Policy>(
                &g_RefInformationInterface, nn::pm::detail::PortNameForInformation);
        if( result.IsSuccess() )
        {
            g_IsInitialized = true;
        }

        return result;
    }

    Result FinalizeForInformation() NN_NOEXCEPT
    {
        NN_ABORT("not implemented");
        return ResultSuccess();
    }

    Result GetProgramId(ncm::ProgramId* pOut, nn::os::ProcessId processId) NN_NOEXCEPT
    {
        return g_RefInformationInterface->GetProgramId(pOut, processId);
    }

}}
