﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

// 以下は固定で using を推奨
using Nintendo;
using Nintendo.ServiceFramework;
using Nintendo.ServiceFramework.CppCode;
using nn;
using nn.sf;
using std;


namespace nn.pinmux
{

    // 実操作を担当する PINMUX のセッションオブジェクト。
    // セッションの取得は Manager で行う。
    [CppRefPath("<nn/pinmux/pinmux_ISession.sfdl.h>")]
    interface ISession : IServiceObject
    {
        [MethodId(0)]
        Result SetPinAssignment(int32_t assignment);

        [MethodId(1)]
        Result GetPinAssignment(Out<int32_t> assignment);

        [MethodId(2)]
        Result SetPinAssignmentForHardwareTest(int32_t assignment);
    }

    [CppRefPath("<nn/pinmux/pinmux_IManager.sfdl.h>")]
    interface IManager : IServiceObject
    {
        [MethodId(0)]
        Result OpenSession(Out<ISession> outSession, int32_t name);
    }
}
