﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/dd.h>

#include <nne/pinmux/pinmux.h>

#include <nn/pinmux/pinmux_TypeForHardwareTest.h>

#include "pinmux_GpioRegAccessor-soc.tegra.h"

namespace nn{
namespace pinmux{
namespace driver{
namespace detail{

// 該当ピンの GPIO の番号と Pinmux の番号の組み合わせの構造体
struct GpioPinmuxCombination
{
    int    gpioNumber;
    nne::pinmux::tegra::tx1::PinmuxPadIndex    pinmuxNumber;
};

// 以下、各定義値が抱える Pinmux の内部番号と GPIO の内部番号の定数配列

//AssignablePinGroupName_ExtConUTx
const GpioPinmuxCombination ExtConUTxNumbers[] =
{
    // UART_TX と GPIO の共有ピン
    { NN_GPIO_GET_PAD_NUM(nn::pinmux::driver::detail::GpioPadPort_PG, 0) ,nne::pinmux::tegra::tx1::PinmuxPadIndex_Uart2Tx},

    // UART_CTS を　GPIO として使うためのピン
    { NN_GPIO_GET_PAD_NUM(nn::pinmux::driver::detail::GpioPadPort_PG, 3) ,nne::pinmux::tegra::tx1::PinmuxPadIndex_Uart2Cts},
};
const int NumberOfExtConUTxPin = sizeof(ExtConUTxNumbers) / sizeof(ExtConUTxNumbers[0]);

//AssignablePinGroupName_ExtConSTx
const GpioPinmuxCombination ExtConSTxNumbers[] =
{
    // UART_TX と GPIO の共有ピン
    { NN_GPIO_GET_PAD_NUM(nn::pinmux::driver::detail::GpioPadPort_PD, 1) ,nne::pinmux::tegra::tx1::PinmuxPadIndex_Uart3Tx},

    // UART_CTS を　GPIO として使うためのピン
    { NN_GPIO_GET_PAD_NUM(nn::pinmux::driver::detail::GpioPadPort_PD, 4) ,nne::pinmux::tegra::tx1::PinmuxPadIndex_Uart3Cts},
};
const int NumberOfExtConSTxPin = sizeof(ExtConSTxNumbers) / sizeof(ExtConSTxNumbers[0]);

//AssignablePinGroupName_Sdmmc1
const GpioPinmuxCombination Sdmmc1Numbers[] =
{
    { NN_GPIO_GET_PAD_NUM(nn::pinmux::driver::detail::GpioPadPort_PM, 0) ,nne::pinmux::tegra::tx1::PinmuxPadIndex_Sdmmc1Clk},
    { NN_GPIO_GET_PAD_NUM(nn::pinmux::driver::detail::GpioPadPort_PM, 1) ,nne::pinmux::tegra::tx1::PinmuxPadIndex_Sdmmc1Cmd},
    { NN_GPIO_GET_PAD_NUM(nn::pinmux::driver::detail::GpioPadPort_PM, 2) ,nne::pinmux::tegra::tx1::PinmuxPadIndex_Sdmmc1Dat3},
    { NN_GPIO_GET_PAD_NUM(nn::pinmux::driver::detail::GpioPadPort_PM, 3) ,nne::pinmux::tegra::tx1::PinmuxPadIndex_Sdmmc1Dat2},
    { NN_GPIO_GET_PAD_NUM(nn::pinmux::driver::detail::GpioPadPort_PM, 4) ,nne::pinmux::tegra::tx1::PinmuxPadIndex_Sdmmc1Dat1},
    { NN_GPIO_GET_PAD_NUM(nn::pinmux::driver::detail::GpioPadPort_PM, 5) ,nne::pinmux::tegra::tx1::PinmuxPadIndex_Sdmmc1Dat0},
};
const int NumberOfSdmmc1Pin = sizeof(Sdmmc1Numbers) / sizeof(Sdmmc1Numbers[0]);

// NOTE : 外向きの定義はなし。 GPIO の定義もない。mariko (以降) 専用
const GpioPinmuxCombination Sdmmc2Numbers[] =
{
    { -1 ,nne::pinmux::tegra::tx1::PinmuxPadIndex_Sdmmc2Clk},
    { -1 ,nne::pinmux::tegra::tx1::PinmuxPadIndex_Sdmmc2Cmd},
    { -1 ,nne::pinmux::tegra::tx1::PinmuxPadIndex_Sdmmc2Dat0},
    { -1 ,nne::pinmux::tegra::tx1::PinmuxPadIndex_Sdmmc2Dat1},
    { -1 ,nne::pinmux::tegra::tx1::PinmuxPadIndex_Sdmmc2Dat2},
    { -1 ,nne::pinmux::tegra::tx1::PinmuxPadIndex_Sdmmc2Dat3},
    { -1 ,nne::pinmux::tegra::tx1::PinmuxPadIndex_Sdmmc2Dat4},
    { -1 ,nne::pinmux::tegra::tx1::PinmuxPadIndex_Sdmmc2Dat5},
    { -1 ,nne::pinmux::tegra::tx1::PinmuxPadIndex_Sdmmc2Dat6},
    { -1 ,nne::pinmux::tegra::tx1::PinmuxPadIndex_Sdmmc2Dat7},
};
const int NumberOfSdmmc2Pin = sizeof(Sdmmc2Numbers) / sizeof(Sdmmc2Numbers[0]);

//AssignablePinGroupNameForHardwareTest_UartD
const GpioPinmuxCombination UartDNumbers[] =
{
    { NN_GPIO_GET_PAD_NUM(nn::pinmux::driver::detail::GpioPadPort_PI, 4) ,nne::pinmux::tegra::tx1::PinmuxPadIndex_Uart4Tx},
    { NN_GPIO_GET_PAD_NUM(nn::pinmux::driver::detail::GpioPadPort_PI, 5) ,nne::pinmux::tegra::tx1::PinmuxPadIndex_Uart4Rx},
    { NN_GPIO_GET_PAD_NUM(nn::pinmux::driver::detail::GpioPadPort_PI, 6) ,nne::pinmux::tegra::tx1::PinmuxPadIndex_Uart4Rts},
    { NN_GPIO_GET_PAD_NUM(nn::pinmux::driver::detail::GpioPadPort_PI, 7) ,nne::pinmux::tegra::tx1::PinmuxPadIndex_Uart4Cts},
};
const int NumberOfUartDPin = sizeof(UartDNumbers) / sizeof(UartDNumbers[0]);

// AssignablePinGroupName_PwmFan
const GpioPinmuxCombination PwmFanNumbers[] =
{
    { NN_GPIO_GET_PAD_NUM(nn::pinmux::driver::detail::GpioPadPort_PV, 4) ,nne::pinmux::tegra::tx1::PinmuxPadIndex_LcdGpio2},
};
const int NumberOfPwmFanPin = sizeof(PwmFanNumbers) / sizeof(PwmFanNumbers[0]);


// 定数配列のポインタと内部の数の構造体定義
struct PinmuxGroup
{
    const GpioPinmuxCombination* pCombination;
    const int number;
};

// AssignablePinName から値を引ける構造体定義
// Index 番号が AssignablePinGroupName と一致するようにすること
const PinmuxGroup PinmuxGroupList[] =
{
    {ExtConUTxNumbers , NumberOfExtConUTxPin},
    {ExtConSTxNumbers , NumberOfExtConSTxPin},
    {Sdmmc1Numbers    , NumberOfSdmmc1Pin},
    {PwmFanNumbers    , NumberOfPwmFanPin},

    // For Hardware Test はここに載せなくてよい。
    //{UartDNumbers     , NumberOfUartDPin},
};


// 各 InternalNumber が指定できる PinAssignment のチェック用 API
inline bool IsSupportPinAssignment(int internalNumber, int assignment)
{
    switch(internalNumber)
    {
#if defined(NN_BUILD_CONFIG_SPEC_NX)
    case static_cast<int>(AssignablePinGroupName_ExtConUTx):
        if(assignment == static_cast<int>(PinAssignment_ExtConTxUart) || assignment == static_cast<int>(PinAssignment_ExtConTxGpio))
        {
            return true;
        }
        break;

    case static_cast<int>(AssignablePinGroupName_ExtConSTx):
        if(assignment == static_cast<int>(PinAssignment_ExtConTxUart) || assignment == static_cast<int>(PinAssignment_ExtConTxGpio))
        {
            return true;
        }
        break;

    case static_cast<int>(AssignablePinGroupNameForHardwareTest_UartD):
        if(assignment == static_cast<int>(PinAssignmentForHardwareTest_UartDHiZ) || assignment == static_cast<int>(PinAssignmentForHardwareTest_UartDEnable))
        {
            return true;
        }
        break;

    case static_cast<int>(AssignablePinGroupName_PwmFan):
        if(assignment == static_cast<int>(PinAssignment_PwmFanPwm) || assignment == static_cast<int>(PinAssignment_PwmFanGpio))
        {
            return true;
        }
        break;

#endif
    case static_cast<int>(AssignablePinGroupName_Sdmmc1):
        if(assignment == PinAssignment_Sdmmc1OutputHigh
           || assignment == PinAssignment_Sdmmc1ResetState
           || assignment == PinAssignment_Sdmmc1SchmtEnable
           || assignment == PinAssignment_Sdmmc1SchmtDisable)
        {
            return true;
        }
        break;

    default : NN_UNEXPECTED_DEFAULT;
    }
    return false;
}





} // detail
} // driver
} // pinmux
} // nn
