﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <new>
#include <mutex>
#include <cstring>

#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/os/os_Config.h>

#include <nn/osdbg/osdbg_ThreadApi.h>
#include <nn/osdbg/osdbg_ThreadTypes.h>

#if defined(NN_BUILD_CONFIG_OS_HORIZON)
    #include "detail/osdbg_ThreadInfo-os.horizon.h"
#else
    #error "未対応の OS 種別が指定されています。"
#endif

namespace nn { namespace osdbg {

//---------------------------------------------------------------------------
//  ThreadInfo 構造体を初期化してスレッド情報を取得
nn::Result InitializeThreadInfo(
                ThreadInfo*                            pThreadInfo,
                nn::svc::Handle                        debugHandle,
                const nn::svc::DebugInfoCreateProcess* pDebugInfoCreateProcess,
                const nn::svc::DebugInfoCreateThread*  pDebugInfoCreateThread
            ) NN_NOEXCEPT
{
    pThreadInfo->_threadType             = NULL;
    pThreadInfo->_debugHandle            = debugHandle;
    pThreadInfo->_debugInfoCreateProcess = *pDebugInfoCreateProcess;
    pThreadInfo->_debugInfoCreateThread  = *pDebugInfoCreateThread;

    return detail::ThreadInfoImpl::FillWithCurrentInfo(pThreadInfo);
}


//---------------------------------------------------------------------------
//  ThreadInfo 構造体にスレッドの最新情報を取得
nn::Result UpdateThreadInfo(ThreadInfo* pThreadInfo) NN_NOEXCEPT
{
    return detail::ThreadInfoImpl::FillWithCurrentInfo(pThreadInfo);
}


//---------------------------------------------------------------------------

}} // namespace nn::osdbg

