﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>

#include <nn/os/os_Macro.h>
#include <nn/os/os_MutexCommon.h>
#include <nn/os/os_MutexTypes.h>
#include <nn/os/os_MutexApi.h>

#include <nnc/os/os_Macro.h>
#include <nnc/os/os_MutexCommon.h>
#include <nnc/os/os_MutexTypes.h>
#include <nnc/os/os_MutexApi.h>

#include "detail/os_Diag.h"
#include "detail/os_Common.h"

//---------------------------------------------------------------------------
//  C++ 用の型とサイズやアライメント、定数値等が一致しているのかをチェック
//---------------------------------------------------------------------------

static_assert(sizeof(nnosMutexType) == sizeof(nn::os::MutexType), "");
static_assert(NN_ALIGNOF(nnosMutexType) == NN_ALIGNOF(nn::os::MutexType), "");

static_assert(NN_OS_MUTEX_LOCK_LEVEL_MIN == nn::os::MutexLockLevelMin, "");
static_assert(NN_OS_MUTEX_LOCK_LEVEL_MAX == nn::os::MutexLockLevelMax, "");
static_assert(NN_OS_MUTEX_LOCK_LEVEL_INITIAL == nn::os::MutexLockLevelInitial, "");
static_assert(NN_OS_MUTEX_RECURSIVE_LOCK_COUNT_MAX == nn::os::MutexRecursiveLockCountMax, "");


//---------------------------------------------------------------------------
//  C 関数の定義
//---------------------------------------------------------------------------

NN_OS_EXTERN_C void nnosInitializeMutex(nnosMutexType* mutex, bool recursive, int lockLevel)
{
    nn::os::InitializeMutex(reinterpret_cast<nn::os::MutexType*>(mutex), recursive, lockLevel);
}

NN_OS_EXTERN_C void nnosFinalizeMutex(nnosMutexType* mutex)
{
    nn::os::FinalizeMutex(reinterpret_cast<nn::os::MutexType*>(mutex));
}

NN_OS_EXTERN_C void nnosLockMutex(nnosMutexType* mutex)
{
    nn::os::LockMutex(reinterpret_cast<nn::os::MutexType*>(mutex));
}

NN_OS_EXTERN_C bool nnosTryLockMutex(nnosMutexType* mutex)
{
    return nn::os::TryLockMutex(reinterpret_cast<nn::os::MutexType*>(mutex));
}

NN_OS_EXTERN_C void nnosUnlockMutex(nnosMutexType* mutex)
{
    nn::os::UnlockMutex(reinterpret_cast<nn::os::MutexType*>(mutex));
}

