﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_TimeSpan.h>

#include <nn/os/os_Macro.h>
#include <nn/os/os_MultipleWaitTypes.h>
#include <nn/os/os_MultipleWaitApi.h>

#include <nnc/os/os_Macro.h>
#include <nnc/os/os_MultipleWaitTypes.h>
#include <nnc/os/os_MultipleWaitApi.h>
#include <nnc/os/os_MultipleWaitCommon.h>

//---------------------------------------------------------------------------
//  C++ 用の型とサイズやアライメントが一致しているのかをチェック
//---------------------------------------------------------------------------

static_assert(sizeof(nnosMultiWaitType) == sizeof(nn::os::MultiWaitType), "");
static_assert(NN_ALIGNOF(nnosMultiWaitType) == NN_ALIGNOF(nn::os::MultiWaitType), "");
static_assert(sizeof(nnosMultiWaitHolderType) == sizeof(nn::os::MultiWaitHolderType), "");
static_assert(NN_ALIGNOF(nnosMultiWaitHolderType) == NN_ALIGNOF(nn::os::MultiWaitHolderType), "");

static_assert(static_cast<int>(nnosMessageQueueWaitType_WaitForNotFull)  == static_cast<int>(nn::os::MessageQueueWaitType_WaitForNotFull), "");
static_assert(static_cast<int>(nnosMessageQueueWaitType_WaitForNotEmpty) == static_cast<int>(nn::os::MessageQueueWaitType_WaitForNotEmpty), "");


//---------------------------------------------------------------------------
//  C 関数の定義
//---------------------------------------------------------------------------

NN_OS_EXTERN_C void    nnosInitializeMultiWait( nnosMultiWaitType* multiWait )
{
    nn::os::InitializeMultiWait(reinterpret_cast<nn::os::MultiWaitType*>(multiWait));
}

NN_OS_EXTERN_C void    nnosFinalizeMultiWait( nnosMultiWaitType* multiWait )
{
    nn::os::FinalizeMultiWait(reinterpret_cast<nn::os::MultiWaitType*>(multiWait));
}

NN_OS_EXTERN_C nnosMultiWaitHolderType* nnosWaitAny( nnosMultiWaitType* multiWait )
{
    auto holder = nn::os::WaitAny(reinterpret_cast<nn::os::MultiWaitType*>(multiWait));
    return reinterpret_cast<nnosMultiWaitHolderType*>(holder);
}

NN_OS_EXTERN_C nnosMultiWaitHolderType* nnosTryWaitAny( nnosMultiWaitType* multiWait )
{
    auto holder = nn::os::TryWaitAny(reinterpret_cast<nn::os::MultiWaitType*>(multiWait));
    return reinterpret_cast<nnosMultiWaitHolderType*>(holder);
}

NN_OS_EXTERN_C nnosMultiWaitHolderType* nnosTimedWaitAny( nnosMultiWaitType* multiWait, int64_t timeout )
{
    auto holder = nn::os::TimedWaitAny(reinterpret_cast<nn::os::MultiWaitType*>(multiWait), nn::TimeSpan::FromNanoSeconds(timeout));
    return reinterpret_cast<nnosMultiWaitHolderType*>(holder);
}

NN_OS_EXTERN_C void    nnosFinalizeMultiWaitHolder( nnosMultiWaitHolderType* multiWaitHolder )
{
    nn::os::FinalizeMultiWaitHolder(reinterpret_cast<nn::os::MultiWaitHolderType*>(multiWaitHolder));
}

NN_OS_EXTERN_C void    nnosLinkMultiWaitHolder(nnosMultiWaitType* multiWait, nnosMultiWaitHolderType* multiWaitHolder)
{
    nn::os::LinkMultiWaitHolder(reinterpret_cast<nn::os::MultiWaitType*>(multiWait), reinterpret_cast<nn::os::MultiWaitHolderType*>(multiWaitHolder));
}

NN_OS_EXTERN_C void    nnosUnlinkMultiWaitHolder(nnosMultiWaitHolderType* multiWaitHolder)
{
    nn::os::UnlinkMultiWaitHolder(reinterpret_cast<nn::os::MultiWaitHolderType*>(multiWaitHolder));
}

NN_OS_EXTERN_C void    nnosUnlinkAllMultiWaitHolder(nnosMultiWaitType* multiWait)
{
    nn::os::UnlinkAllMultiWaitHolder(reinterpret_cast<nn::os::MultiWaitType*>(multiWait));
}

NN_OS_EXTERN_C void    nnosMoveAllMultiWaitHolder(nnosMultiWaitType* dstMultiWait, nnosMultiWaitType* srcMultiWait)
{
    nn::os::MoveAllMultiWaitHolder(reinterpret_cast<nn::os::MultiWaitType*>(dstMultiWait), reinterpret_cast<nn::os::MultiWaitType*>(srcMultiWait));
}

NN_OS_EXTERN_C void    nnosSetMultiWaitHolderUserData(nnosMultiWaitHolderType* multiWaitHolder, uintptr_t userData)
{
    nn::os::SetMultiWaitHolderUserData(reinterpret_cast<nn::os::MultiWaitHolderType*>(multiWaitHolder), userData);
}

NN_OS_EXTERN_C uintptr_t nnosGetMultiWaitHolderUserData(const nnosMultiWaitHolderType* multiWaitHolder)
{
    return nn::os::GetMultiWaitHolderUserData(reinterpret_cast<const nn::os::MultiWaitHolderType*>(multiWaitHolder));
}
