﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>

#include "os_Diag.h"
#include "os_Common.h"
#include "os_Utility.h"

namespace nn { namespace os {
namespace detail {

//-----------------------------------------------------------------------------
//  指定された符号なし数値を ASCII 文字列に展開する。先頭の 0x は付かない。
//  例えば value=0x12345678, bitWidth=16 を指定すると下位 16bit のみを
//  展開するので、buf に "5678" と終端のヌル文字が書き込まれる。
//
//  bitWidth は 4 の倍数でなければならない。
//  buf には予め十分なサイズの領域が必要である。
//-----------------------------------------------------------------------------

void ExpandUnsignedValueToAscii(char* buf, uint64_t value, int bitWidth) NN_NOEXCEPT
{
    char*   dst    = buf;
    int     column = bitWidth / 4;

    for (int i=0; i<column; ++i)
    {
        char c = (value >> ((column - i - 1) * 4)) & 0xF;
        *dst++ = c + ((c >= 0xa) ? 'A' - 0xa : '0');
    }
    *dst = '\0';
}

//-----------------------------------------------------------------------------

}  // namespace detail
}} // namespace nn::os

