﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/os/os_Config.h>

#if !defined(NN_BUILD_CONFIG_OS_SUPPORTS_WIN32)
    #error  "OS 種別として Win32 が指定されていません。"
#endif

#include <nn/nn_Windows.h>
#include <nn/nn_Macro.h>
#include <nn/nn_TimeSpan.h>
#include <nn/os/os_Tick.h>

//--------------------------------------------------------------------------

namespace nn { namespace os {
namespace detail {

//--------------------------------------------------------------------------
//  TickManagerImplByWin32 クラス
//

class   TickManagerImplByWin32
{
public:
    TickManagerImplByWin32()    NN_NOEXCEPT;
    ~TickManagerImplByWin32()   NN_NOEXCEPT;

    Tick        GetTick() const                         NN_NOEXCEPT;
    int64_t     GetTickFrequency() const                NN_NOEXCEPT
    {
        return m_TickFrequency;
    }

private:
    int64_t     m_TickFrequency;
};

typedef TickManagerImplByWin32   TickManagerImpl;

}   // namespace detail
}}  // namespace nn::os

