﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/os/os_Config.h>

#include <nn/nn_Macro.h>
#include <nn/nn_SdkAssert.h>
#include <nn/nn_Result.h>
#include <nn/os/detail/os_InternalCriticalSection.h>
#include <nn/util/util_TinyMt.h>

namespace nn { namespace os {

namespace detail {

// Random Number Generator 管理クラス
class RngManager
{
public:
    //-----------------------------------------------------------------
    // コンストラクタ
    RngManager() NN_NOEXCEPT;

    //-----------------------------------------------------------------
    // 符号なし 64 bit 整数乱数を生成
    uint64_t GenerateRandomU64() NN_NOEXCEPT;

private:
    InternalCriticalSection     m_CriticalSection;  // クリティカルセクション
    util::TinyMt                m_Random;
};

}   // namespace detail
}}  // namespace nn::os
