﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/os/os_Config.h>
#include <nn/nn_Common.h>
#include <nn/nn_SdkAssert.h>
#include <nn/nn_SdkLog.h>
#include <nn/os/os_Tick.h>
#include "os_RandomImpl.h"

//-----------------------------------------------------------------------------

namespace nn { namespace os {
namespace detail {

void InitializeRandomImpl(util::TinyMt* random) NN_NOEXCEPT
{
    // 擬似乱数発生器を初期化
    random->Initialize(static_cast<Bit32>(nn::os::GetSystemTick().GetInt64Value()));
}

}   // namespace detail
}}  // namespace nn::os
